/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

@Entity
public class BdbTopicConfEntity
implements Serializable {
    private static final long serialVersionUID = -3266492818900652275L;
    @PrimaryKey
    private String recordKey;
    private int topicStatusId = 0;
    private int brokerId = -2;
    private String brokerIp;
    private int brokerPort;
    private String brokerAddress;
    private String topicName;
    private int numPartitions = -2;
    private int unflushThreshold = -2;
    private int unflushInterval = -2;
    private boolean acceptPublish = true;
    private boolean acceptSubscribe = true;
    private int numTopicStores = 1;
    private String deleteWhen;
    private String deletePolicy;
    private int dataStoreType = -2;
    private String dataPath;
    private String attributes;
    private String createUser;
    private Date createDate;
    private String modifyUser;
    private Date modifyDate;

    public BdbTopicConfEntity() {
    }

    public BdbTopicConfEntity(int brokerId, String brokerIp, int brokerPort, String topicName, int numPartitions, int unflushThreshold, int unflushInterval, String deleteWhen, String deletePolicy, boolean acceptPublish, boolean acceptSubscribe, int numTopicStores, String attributes, String createUser, Date createDate, String modifyUser, Date modifyDate) {
        StringBuilder sBuilder = new StringBuilder(512);
        this.recordKey = sBuilder.append(brokerId).append(":").append(topicName).toString();
        sBuilder.delete(0, sBuilder.length());
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
        this.brokerPort = brokerPort;
        this.brokerAddress = sBuilder.append(this.brokerIp).append(":").append(this.brokerPort).toString();
        this.topicName = topicName;
        this.numPartitions = numPartitions;
        this.unflushThreshold = unflushThreshold;
        this.unflushInterval = unflushInterval;
        this.deleteWhen = deleteWhen;
        this.deletePolicy = deletePolicy;
        this.acceptPublish = acceptPublish;
        this.acceptSubscribe = acceptSubscribe;
        this.numTopicStores = numTopicStores;
        this.createUser = createUser;
        this.createDate = createDate;
        this.modifyUser = modifyUser;
        this.modifyDate = modifyDate;
        this.attributes = attributes;
    }

    public void setBrokerAndTopicInfo(int brokerId, String brokerIp, int brokerPort, String topicName) {
        StringBuilder sBuilder = new StringBuilder(512);
        this.recordKey = sBuilder.append(brokerId).append(":").append(topicName).toString();
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
        this.brokerPort = brokerPort;
        if (this.brokerPort != -2) {
            sBuilder.delete(0, sBuilder.length());
            this.brokerAddress = sBuilder.append(brokerIp).append(":").append(brokerPort).toString();
        }
        this.topicName = topicName;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public int getNumTopicStores() {
        if (this.numTopicStores == 0) {
            return 1;
        }
        return this.numTopicStores;
    }

    public void setNumTopicStores(int numTopicStores) {
        this.numTopicStores = numTopicStores;
    }

    public void setUnflushDataHold(int unFlushDataHold) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"unFlushDataHold", (String)String.valueOf(unFlushDataHold));
    }

    public void setDataStore(int dataStoreType, String dataPath) {
        this.dataPath = dataPath;
        this.dataStoreType = dataStoreType;
    }

    public int getDataStoreType() {
        return this.dataStoreType;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public int getUnflushThreshold() {
        return this.unflushThreshold;
    }

    public void setUnflushThreshold(int unflushThreshold) {
        this.unflushThreshold = unflushThreshold;
    }

    public int getUnflushInterval() {
        return this.unflushInterval;
    }

    public void setUnflushInterval(int unflushInterval) {
        this.unflushInterval = unflushInterval;
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public void setDeleteWhen(String deleteWhen) {
        this.deleteWhen = deleteWhen;
    }

    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    public void setDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public int getTopicStatusId() {
        return this.topicStatusId;
    }

    public void setTopicStatusId(int topicStatusId) {
        this.topicStatusId = topicStatusId;
    }

    public boolean isValidTopicStatus() {
        return this.topicStatusId == 0;
    }

    public boolean getAcceptPublish() {
        return this.acceptPublish;
    }

    public void setAcceptPublish(boolean acceptPublish) {
        this.acceptPublish = acceptPublish;
    }

    public boolean getAcceptSubscribe() {
        return this.acceptSubscribe;
    }

    public void setAcceptSubscribe(boolean acceptSubscribe) {
        this.acceptSubscribe = acceptSubscribe;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getBrokerIp() {
        return this.brokerIp;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public int getUnflushDataHold() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"unFlushDataHold");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 0;
    }

    public int getMemCacheMsgCntInK() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheMsgCntInK");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 10;
    }

    public void setMemCacheMsgCntInK(int memCacheMsgCntInK) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheMsgCntInK", (String)String.valueOf(memCacheMsgCntInK));
    }

    public int getMemCacheMsgSizeInMB() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheMsgSizeInMB");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 2;
    }

    public void setMemCacheMsgSizeInMB(int memCacheMsgSizeInMB) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheMsgSizeInMB", (String)String.valueOf(memCacheMsgSizeInMB));
    }

    public int getMemCacheFlushIntvl() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"memCacheFlushIntvl");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 20000;
    }

    public void setMemCacheFlushIntvl(int memCacheFlushIntvl) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"memCacheFlushIntvl", (String)String.valueOf(memCacheFlushIntvl));
    }

    public int getMaxMsgSize() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"maxMsgSize");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"maxMsgSize", (String)String.valueOf(maxMsgSize));
    }

    public long getDataVerId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataVerId");
        if (atrVal != null) {
            return Long.parseLong(atrVal);
        }
        return -2L;
    }

    public void setDataVerId(long dataVerId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataVerId", (String)String.valueOf(dataVerId));
    }

    public int getTopicId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"topicId");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setTopicId(int topicId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"topicId", (String)String.valueOf(topicId));
    }

    public void appendAttributes(String attrKey, String attrVal) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)attrKey, (String)attrVal);
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"type\":\"BdbTopicConfEntity\",").append("\"recordKey\":\"").append(this.recordKey).append("\",\"topicStatusId\":\"").append(this.topicStatusId).append("\",\"brokerId\":\"").append(this.brokerId).append("\",\"brokerAddress\":\"").append(this.brokerAddress).append("\",\"topicName\":\"").append(this.topicName).append("\",\"numPartitions\":").append(this.numPartitions).append(",\"unflushThreshold\":").append(this.unflushThreshold).append(",\"unflushDataHold\":").append(this.getUnflushDataHold()).append(",\"unflushInterval\":").append(this.unflushInterval).append(",\"deleteWhen\":\"").append(this.deleteWhen).append("\",\"deletePolicy\":\"").append(this.deletePolicy).append(",\"acceptPublish\":").append(this.acceptPublish).append(",\"acceptSubscribe\":").append(this.acceptSubscribe).append(",\"numTopicStores\":").append(this.numTopicStores).append(",\"memCacheMsgCntInK\":").append(this.getMemCacheMsgCntInK()).append(",\"memCacheMsgSizeInMB\":").append(this.getMemCacheMsgSizeInMB()).append(",\"memCacheFlushIntvl\":").append(this.getMemCacheFlushIntvl()).append(",\"maxMsgSize\":").append(this.getMaxMsgSize()).append(",\"dataPath\":\"").append(this.dataPath).append("\",\"createUser\":\"").append(this.createUser).append("\",\"createDate\":\"").append(DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate)).append("\",\"modifyUser\":\"").append(this.modifyUser).append("\",\"modifyDate\":\"").append(DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.modifyDate)).append("\"}");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("recordKey", (Object)this.recordKey).append("topicStatusId", this.topicStatusId).append("brokerId", this.brokerId).append("brokerIp", (Object)this.brokerIp).append("brokerPort", this.brokerPort).append("brokerAddress", (Object)this.brokerAddress).append("topicName", (Object)this.topicName).append("numPartitions", this.numPartitions).append("unflushThreshold", this.unflushThreshold).append("unflushInterval", this.unflushInterval).append("acceptPublish", this.acceptPublish).append("acceptSubscribe", this.acceptSubscribe).append("numTopicStores", this.numTopicStores).append("deleteWhen", (Object)this.deleteWhen).append("deletePolicy", (Object)this.deletePolicy).append("dataStoreType", this.dataStoreType).append("dataPath", (Object)this.dataPath).append("attributes", (Object)this.attributes).append("createUser", (Object)this.createUser).append("createDate", (Object)this.createDate).append("modifyUser", (Object)this.modifyUser).append("modifyDate", (Object)this.modifyDate).toString();
    }
}

