/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset.offsetfile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.server.broker.offset.OffsetStorageInfo;
import org.apache.inlong.tubemq.server.broker.offset.offsetfile.PartStgInfo;

public class OffsetStgInfo {
    private long lstCommitTime;
    private final ConcurrentHashMap<String, PartStgInfo> partOffsetInfo = new ConcurrentHashMap();

    public boolean updOffsetInfo(String topic, int partId, long lstTerm, long msgId, long offset, long lstUpdateTime) {
        PartStgInfo tmpPartInfo;
        boolean isAdded = false;
        String key = OffsetStgInfo.buildOffsetKey(topic, partId);
        PartStgInfo partInfo = this.partOffsetInfo.get(key);
        if (partInfo == null && (partInfo = this.partOffsetInfo.putIfAbsent(key, tmpPartInfo = new PartStgInfo(topic, partId))) == null) {
            isAdded = true;
            partInfo = tmpPartInfo;
        }
        partInfo.updateOffset(lstTerm, msgId, isAdded, offset, lstUpdateTime, offset, lstUpdateTime);
        this.lstCommitTime = lstUpdateTime;
        return isAdded;
    }

    public boolean updOffsetInfo(OffsetStorageInfo info) {
        PartStgInfo tmpPartInfo;
        boolean isAdded = false;
        String key = OffsetStgInfo.buildOffsetKey(info.getTopic(), info.getPartitionId());
        PartStgInfo partInfo = this.partOffsetInfo.get(key);
        if (partInfo == null && (partInfo = this.partOffsetInfo.putIfAbsent(key, tmpPartInfo = new PartStgInfo(info.getTopic(), info.getPartitionId()))) == null) {
            isAdded = true;
            partInfo = tmpPartInfo;
        }
        partInfo.updateOffset(info.getLstRstTerm(), info.getMessageId(), isAdded, info.getFirstOffset(), info.getCreateTime(), info.getOffset(), info.getLstUpdateTime());
        this.lstCommitTime = info.getLstUpdateTime();
        return isAdded;
    }

    public boolean resetOffsetInfo(String topic, int partId, long resetTerm, long offset, long lstUpdateTime) {
        PartStgInfo tmpPartInfo;
        boolean isAdded = false;
        String key = OffsetStgInfo.buildOffsetKey(topic, partId);
        PartStgInfo partInfo = this.partOffsetInfo.get(key);
        if (partInfo == null && (partInfo = this.partOffsetInfo.putIfAbsent(key, tmpPartInfo = new PartStgInfo(topic, partId))) == null) {
            isAdded = true;
            partInfo = tmpPartInfo;
        }
        partInfo.resetOffset(resetTerm, isAdded, offset, lstUpdateTime);
        this.lstCommitTime = lstUpdateTime;
        return isAdded;
    }

    public long getLstCommitTime() {
        return this.lstCommitTime;
    }

    public boolean isOffsetStgInfoEmpty() {
        return this.partOffsetInfo.isEmpty();
    }

    public boolean includedTopic(String topic) {
        if (this.partOffsetInfo.isEmpty()) {
            return false;
        }
        for (PartStgInfo partStgInfo : this.partOffsetInfo.values()) {
            if (partStgInfo == null || !topic.equals(partStgInfo.getTopic())) continue;
            return true;
        }
        return false;
    }

    public PartStgInfo getPartOffsetInfo(String topic, int partId) {
        return this.partOffsetInfo.get(OffsetStgInfo.buildOffsetKey(topic, partId));
    }

    public ConcurrentHashMap<String, PartStgInfo> getPartOffsetInfo() {
        return this.partOffsetInfo;
    }

    public Map<Integer, Long> getPartOffsetInfo(String topic, Set<Integer> partIds) {
        HashMap<Integer, Long> offsetMap = new HashMap<Integer, Long>(partIds.size());
        for (Integer partId : partIds) {
            PartStgInfo partInfo = this.partOffsetInfo.get(OffsetStgInfo.buildOffsetKey(topic, partId));
            if (partInfo == null) {
                offsetMap.put(partId, null);
                continue;
            }
            offsetMap.put(partId, partInfo.getLstOffset());
        }
        return offsetMap;
    }

    public boolean rmvPartOffsetInfo(String topic, Set<Integer> partIds) {
        for (Integer partId : partIds) {
            this.partOffsetInfo.remove(OffsetStgInfo.buildOffsetKey(topic, partId));
        }
        return this.partOffsetInfo.isEmpty();
    }

    public boolean rmvPartOffsetInfo(Set<String> rmvTopics) {
        HashSet<String> rmvItems = new HashSet<String>();
        for (Map.Entry<String, PartStgInfo> entry : this.partOffsetInfo.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null || !rmvTopics.contains(entry.getValue().getTopic())) continue;
            rmvItems.add(OffsetStgInfo.buildOffsetKey(entry.getValue().getTopic(), entry.getValue().getPartId()));
        }
        for (String rmvItem : rmvItems) {
            this.partOffsetInfo.remove(rmvItem);
        }
        return this.partOffsetInfo.isEmpty();
    }

    public String toString() {
        return "OffsetStgInfo{lstCommitTime=" + this.lstCommitTime + ", partOffsetInfo=" + this.partOffsetInfo + '}';
    }

    public static String buildOffsetKey(String topic, int partId) {
        return topic + "-" + partId;
    }
}

