/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTopicSelector;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.schema.TopicSelector;
import java.util.Collections;

public class MongoDbTaskContext
extends CdcSourceTaskContext {
    private final Filters filters;
    private final SourceInfo source;
    private final TopicSelector<CollectionId> topicSelector;
    private final String serverName;
    private final ConnectionContext connectionContext;
    private final MongoDbConnectorConfig connectorConfig;
    private MongoDbConnectorConfig.CaptureMode captureMode;

    public MongoDbTaskContext(Configuration config) {
        super(Module.contextName(), config.getString(MongoDbConnectorConfig.LOGICAL_NAME), Collections::emptySet);
        String serverName = config.getString(MongoDbConnectorConfig.LOGICAL_NAME);
        this.filters = new Filters(config);
        this.connectorConfig = new MongoDbConnectorConfig(config);
        this.source = new SourceInfo(this.connectorConfig);
        this.topicSelector = MongoDbTopicSelector.defaultSelector(serverName, this.connectorConfig.getHeartbeatTopicsPrefix());
        this.serverName = config.getString(MongoDbConnectorConfig.LOGICAL_NAME);
        this.connectionContext = new ConnectionContext(config);
        this.overrideCaptureMode(this.connectorConfig.getCaptureMode());
    }

    public TopicSelector<CollectionId> topicSelector() {
        return this.topicSelector;
    }

    public Filters filters() {
        return this.filters;
    }

    public SourceInfo source() {
        return this.source;
    }

    public String serverName() {
        return this.serverName;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public MongoDbConnectorConfig.CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public void overrideCaptureMode(MongoDbConnectorConfig.CaptureMode captureModeUsed) {
        this.captureMode = captureModeUsed;
    }
}

