/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.node.ConfigurationSource;

public class ClasspathConfigurationSource
implements ConfigurationSource {
    private final String path;
    private final URI uri;

    public ClasspathConfigurationSource(URI uri) {
        this.uri = uri;
        if (StringUtils.isNotEmpty((String)uri.getPath())) {
            this.path = uri.getPath().substring(1);
        } else if (StringUtils.isNotEmpty((String)uri.getAuthority())) {
            this.path = uri.getAuthority();
        } else if (StringUtils.isNotEmpty((String)uri.getSchemeSpecificPart())) {
            this.path = uri.getSchemeSpecificPart();
        } else {
            throw new ConfigurationException("Invalid uri: " + uri);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this.path);
    }

    @Override
    public String getUri() {
        return this.uri.toString();
    }

    @Override
    public String getExtension() {
        int length = this.uri.getPath().indexOf(".");
        if (length <= 1) {
            return "properties";
        }
        return this.uri.getPath().substring(length + 1);
    }

    public String toString() {
        return "{ classpath: " + this.path + "}";
    }
}

