/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.AbstractNodeLabelsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptBasedNodeLabelsProvider
extends AbstractNodeLabelsProvider {
    private String nodeLabelsScriptPath;
    private long scriptTimeout;
    Shell.ShellCommandExecutor shexec = null;
    public static final String NODE_LABEL_PARTITION_PATTERN = "NODE_PARTITION:";
    private String[] scriptArgs;

    public ScriptBasedNodeLabelsProvider() {
        super(ScriptBasedNodeLabelsProvider.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.nodeLabelsScriptPath = conf.get("yarn.nodemanager.node-labels.provider.script.path");
        this.scriptTimeout = conf.getLong("yarn.nodemanager.node-labels.provider.fetch-timeout-ms", 1200000L);
        this.scriptArgs = conf.getStrings("yarn.nodemanager.node-labels.provider.script.opts", new String[0]);
        this.verifyConfiguredScript();
    }

    private void verifyConfiguredScript() throws IOException {
        boolean invalidConfiguration = false;
        if (this.nodeLabelsScriptPath == null || this.nodeLabelsScriptPath.trim().isEmpty()) {
            invalidConfiguration = true;
        } else {
            File f = new File(this.nodeLabelsScriptPath);
            boolean bl = invalidConfiguration = !f.exists() || !FileUtil.canExecute((File)f);
        }
        if (invalidConfiguration) {
            throw new IOException("Distributed Node labels provider script \"" + this.nodeLabelsScriptPath + "\" is not configured properly. Please check whether the script " + "path exists, owner and the access rights are suitable for NM " + "process to execute it");
        }
    }

    @Override
    public void cleanUp() {
        Process p;
        if (this.shexec != null && (p = this.shexec.getProcess()) != null) {
            p.destroy();
        }
    }

    @Override
    public TimerTask createTimerTask() {
        return new NodeLabelsScriptRunner();
    }

    private class NodeLabelsScriptRunner
    extends TimerTask {
        private final Logger LOG = LoggerFactory.getLogger(NodeLabelsScriptRunner.class);

        public NodeLabelsScriptRunner() {
            ArrayList<String> execScript = new ArrayList<String>();
            execScript.add(ScriptBasedNodeLabelsProvider.this.nodeLabelsScriptPath);
            if (ScriptBasedNodeLabelsProvider.this.scriptArgs != null) {
                execScript.addAll(Arrays.asList(ScriptBasedNodeLabelsProvider.this.scriptArgs));
            }
            ScriptBasedNodeLabelsProvider.this.shexec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, ScriptBasedNodeLabelsProvider.this.scriptTimeout);
        }

        @Override
        public void run() {
            try {
                ScriptBasedNodeLabelsProvider.this.shexec.execute();
                ScriptBasedNodeLabelsProvider.this.setNodeLabels(this.fetchLabelsFromScriptOutput(ScriptBasedNodeLabelsProvider.this.shexec.getOutput()));
            }
            catch (Exception e) {
                if (ScriptBasedNodeLabelsProvider.this.shexec.isTimedOut()) {
                    this.LOG.warn("Node Labels script timed out, Caught exception : " + e.getMessage(), (Throwable)e);
                }
                this.LOG.warn("Execution of Node Labels script failed, Caught exception : " + e.getMessage(), (Throwable)e);
            }
        }

        private Set<NodeLabel> fetchLabelsFromScriptOutput(String scriptOutput) throws IOException {
            String[] splits;
            String nodePartitionLabel = null;
            for (String line : splits = scriptOutput.split("\n")) {
                String trimmedLine = line.trim();
                if (!trimmedLine.startsWith(ScriptBasedNodeLabelsProvider.NODE_LABEL_PARTITION_PATTERN)) continue;
                nodePartitionLabel = trimmedLine.substring(ScriptBasedNodeLabelsProvider.NODE_LABEL_PARTITION_PATTERN.length());
            }
            return AbstractNodeLabelsProvider.convertToNodeLabelSet(nodePartitionLabel);
        }
    }
}

