/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.http.server.FSOperations;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.http.server.metrics.HttpFSServerMetrics;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class InputStreamEntity
implements StreamingOutput {
    private InputStream is;
    private long offset;
    private long len;

    public InputStreamEntity(InputStream is, long offset, long len) {
        this.is = is;
        this.offset = offset;
        this.len = len;
    }

    public InputStreamEntity(InputStream is) {
        this(is, 0L, -1L);
    }

    public void write(OutputStream os) throws IOException {
        IOUtils.skipFully((InputStream)this.is, (long)this.offset);
        long bytes = 0L;
        bytes = this.len == -1L ? FSOperations.copyBytes(this.is, os) : FSOperations.copyBytes(this.is, os, this.len);
        HttpFSServerWebApp.get();
        HttpFSServerMetrics metrics = HttpFSServerWebApp.getMetrics();
        if (metrics != null) {
            metrics.incrBytesRead(bytes);
        }
    }
}

