/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteRetryHandler;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.S3AFileSystemOperations;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.impl.StoreContextFactory;
import org.apache.hadoop.fs.s3a.impl.streams.FactoryBindingParameters;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.impl.streams.StreamFactoryRequirements;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.RateLimiting;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.functional.Tuples;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CompletedFileUpload;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

public class S3AStoreImpl
extends CompositeService
implements S3AStore,
ObjectInputStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S3AStoreImpl.class);
    private static final Logger PROGRESS = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.S3AFileSystem.Progress");
    private final StoreContextFactory storeContextFactory;
    private final ClientManager clientManager;
    private final String bucket;
    private final RequestFactory requestFactory;
    private final DurationTrackerFactory durationTrackerFactory;
    private final S3AInstrumentation instrumentation;
    private final S3AStatisticsContext statisticsContext;
    private final S3AStorageStatistics storageStatistics;
    private final RateLimiting readRateLimiter;
    private final RateLimiting writeRateLimiter;
    private final StoreContext storeContext;
    private final Invoker invoker;
    private final AuditSpanSource<AuditSpanS3A> auditSpanSource;
    private final FileSystem.Statistics fsStatistics;
    private LocalDirAllocator directoryAllocator;
    private ObjectInputStreamFactory objectInputStreamFactory;

    S3AStoreImpl(StoreContextFactory storeContextFactory, ClientManager clientManager, DurationTrackerFactory durationTrackerFactory, S3AInstrumentation instrumentation, S3AStatisticsContext statisticsContext, S3AStorageStatistics storageStatistics, RateLimiting readRateLimiter, RateLimiting writeRateLimiter, AuditSpanSource<AuditSpanS3A> auditSpanSource, @Nullable FileSystem.Statistics fsStatistics) {
        super("S3AStore");
        this.auditSpanSource = Objects.requireNonNull(auditSpanSource);
        this.clientManager = Objects.requireNonNull(clientManager);
        this.durationTrackerFactory = Objects.requireNonNull(durationTrackerFactory);
        this.fsStatistics = fsStatistics;
        this.instrumentation = Objects.requireNonNull(instrumentation);
        this.statisticsContext = Objects.requireNonNull(statisticsContext);
        this.storeContextFactory = Objects.requireNonNull(storeContextFactory);
        this.storageStatistics = Objects.requireNonNull(storageStatistics);
        this.readRateLimiter = Objects.requireNonNull(readRateLimiter);
        this.writeRateLimiter = Objects.requireNonNull(writeRateLimiter);
        this.storeContext = Objects.requireNonNull(storeContextFactory.createStoreContext());
        this.invoker = Objects.requireNonNull(this.storeContext.getInvoker());
        this.bucket = Objects.requireNonNull(this.storeContext.getBucket());
        this.requestFactory = Objects.requireNonNull(this.storeContext.getRequestFactory());
        this.addService(clientManager);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.objectInputStreamFactory = StreamIntegration.factoryFromConfig(conf);
        this.addService(this.objectInputStreamFactory);
        super.serviceInit(conf);
        this.finishStreamFactoryInit();
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.initLocalDirAllocator();
    }

    public boolean hasPathCapability(Path path, String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "iostatistics": {
                return true;
            }
        }
        return this.inputStreamHasCapability(capability);
    }

    @Override
    public boolean inputStreamHasCapability(String capability) {
        if (this.objectInputStreamFactory != null) {
            return this.objectInputStreamFactory.hasCapability(capability);
        }
        return false;
    }

    private void initLocalDirAllocator() {
        String key = "fs.s3a.buffer.dir";
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getConfig().getTrimmed(key))) {
            key = "hadoop.tmp.dir";
        }
        this.directoryAllocator = new LocalDirAllocator(key);
    }

    @Override
    public Duration acquireWriteCapacity(int capacity) {
        return this.writeRateLimiter.acquire(capacity);
    }

    @Override
    public Duration acquireReadCapacity(int capacity) {
        return this.readRateLimiter.acquire(capacity);
    }

    private StoreContext createStoreContext() {
        return this.storeContextFactory.createStoreContext();
    }

    @Override
    public StoreContext getStoreContext() {
        return this.storeContext;
    }

    private S3Client getS3Client() throws UncheckedIOException {
        return this.clientManager.getOrCreateS3ClientUnchecked();
    }

    @Override
    public S3TransferManager getOrCreateTransferManager() throws IOException {
        return this.clientManager.getOrCreateTransferManager();
    }

    @Override
    public S3Client getOrCreateS3Client() throws IOException {
        return this.clientManager.getOrCreateS3Client();
    }

    @Override
    public S3AsyncClient getOrCreateAsyncClient() throws IOException {
        return this.clientManager.getOrCreateAsyncClient();
    }

    @Override
    public S3Client getOrCreateS3ClientUnchecked() throws UncheckedIOException {
        return this.clientManager.getOrCreateS3ClientUnchecked();
    }

    @Override
    public S3Client getOrCreateAsyncS3ClientUnchecked() throws UncheckedIOException {
        return this.clientManager.getOrCreateAsyncS3ClientUnchecked();
    }

    @Override
    public S3Client getOrCreateUnencryptedS3Client() throws IOException {
        return this.clientManager.getOrCreateUnencryptedS3Client();
    }

    @Override
    public DurationTrackerFactory getDurationTrackerFactory() {
        return this.durationTrackerFactory;
    }

    private S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public S3AStatisticsContext getStatisticsContext() {
        return this.statisticsContext;
    }

    private S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    @Override
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public ClientManager clientManager() {
        return this.clientManager;
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.statisticsContext.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.statisticsContext.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.statisticsContext.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        if (S3AUtils.isThrottleException(ex)) {
            LOG.debug("Request throttled");
            this.incrementStatistic(Statistic.STORE_IO_THROTTLED);
            this.statisticsContext.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, 1L);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_RETRY);
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public IOStatistics getIOStatistics() {
        return this.instrumentation.getIOStatistics();
    }

    @Override
    public void incrementReadOperations() {
        if (this.fsStatistics != null) {
            this.fsStatistics.incrementReadOps(1);
        }
    }

    @Override
    public void incrementWriteOperations() {
        if (this.fsStatistics != null) {
            this.fsStatistics.incrementWriteOps(1);
        }
    }

    private void incrementBytesWritten(long bytes) {
        if (this.fsStatistics != null) {
            this.fsStatistics.incrementBytesWritten(bytes);
        }
    }

    @Override
    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
        if (bytes > 0L) {
            this.incrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
    }

    @Override
    public void incrementPutCompletedStatistics(boolean success, long bytes) {
        LOG.debug("PUT completed success={}; {} bytes", (Object)success, (Object)bytes);
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
            this.decrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS_COMPLETED);
        this.decrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
    }

    @Override
    public void incrementPutProgressStatistics(String key, long bytes) {
        PROGRESS.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.incrementBytesWritten(bytes);
        }
    }

    @Override
    public DurationTrackerFactory nonNullDurationTrackerFactory(DurationTrackerFactory factory) {
        return factory != null ? factory : this.getDurationTrackerFactory();
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return (AuditSpanS3A)this.auditSpanSource.createSpan(operation, path1, path2);
    }

    private void blockRootDelete(String key) throws IllegalArgumentException {
        Preconditions.checkArgument((!key.isEmpty() && !"/".equals(key) ? 1 : 0) != 0, (String)"Bucket %s cannot be deleted", (Object[])new Object[]{this.bucket});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<Duration, DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest deleteRequest) throws SdkException {
        BulkDeleteRetryHandler retryHandler = new BulkDeleteRetryHandler(this.createStoreContext());
        List keysToDelete = deleteRequest.delete().objects();
        int keyCount = keysToDelete.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating delete operation for {} objects", (Object)keysToDelete.size());
            keysToDelete.stream().forEach(objectIdentifier -> LOG.debug(" \"{}\" {}", (Object)objectIdentifier.key(), (Object)(objectIdentifier.versionId() != null ? objectIdentifier.versionId() : "")));
        }
        keysToDelete.stream().map(ObjectIdentifier::key).forEach(this::blockRootDelete);
        try (DurationInfo d = new DurationInfo(LOG, false, "DELETE %d keys", new Object[]{keyCount});){
            DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoker.retryUntranslated("delete", true, (text, e, r, i) -> retryHandler.bulkDeleteRetried(deleteRequest, e), IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_BULK_DELETE_REQUEST.getSymbol(), () -> {
                Duration durationToAcquireWriteCapacity = this.acquireWriteCapacity(keyCount);
                this.instrumentation.recordDuration(Statistic.STORE_IO_RATE_LIMITED, true, durationToAcquireWriteCapacity);
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS, keyCount);
                return this.getS3Client().deleteObjects(deleteRequest);
            }));
            if (!response.errors().isEmpty()) {
                List errors = response.errors();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Partial failure of delete, {} errors", (Object)errors.size());
                    for (S3Error error : errors) {
                        LOG.debug("{}: \"{}\" - {}", new Object[]{error.key(), error.code(), error.message()});
                    }
                }
            }
            d.close();
            Map.Entry entry = Tuples.pair((Object)d.asDuration(), (Object)response);
            return entry;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public HeadObjectResponse headObject(String key, ChangeTracker changeTracker, Invoker changeInvoker, S3AFileSystemOperations fsHandler, String operation) throws IOException {
        HeadObjectResponse response = (HeadObjectResponse)this.getStoreContext().getInvoker().retryUntranslated("HEAD " + key, true, () -> {
            HeadObjectRequest.Builder requestBuilder = this.getRequestFactory().newHeadObjectRequestBuilder(key);
            this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
            try (DurationTracker duration = this.getDurationTrackerFactory().trackDuration(Statistic.ACTION_HTTP_HEAD_REQUEST.getSymbol());){
                LOG.debug("HEAD {} with change tracker {}", (Object)key, (Object)changeTracker);
                if (changeTracker != null) {
                    changeTracker.maybeApplyConstraint(requestBuilder);
                }
                HeadObjectResponse headObjectResponse = this.getS3Client().headObject((HeadObjectRequest)requestBuilder.build());
                if (fsHandler != null) {
                    long length = fsHandler.getS3ObjectSize(key, headObjectResponse.contentLength(), this, headObjectResponse);
                    headObjectResponse = (HeadObjectResponse)headObjectResponse.toBuilder().contentLength(Long.valueOf(length)).build();
                }
                if (changeTracker != null) {
                    changeTracker.processMetadata(headObjectResponse, operation);
                }
                HeadObjectResponse headObjectResponse2 = headObjectResponse;
                return headObjectResponse2;
            }
        });
        this.incrementReadOperations();
        return response;
    }

    @Override
    public ResponseInputStream<GetObjectResponse> getRangedS3Object(String key, long start, long end) throws IOException {
        ResponseInputStream objectRange;
        GetObjectRequest request = (GetObjectRequest)this.getRequestFactory().newGetObjectRequestBuilder(key).range(S3AUtils.formatRange(start, end)).build();
        try (DurationTracker duration = this.getDurationTrackerFactory().trackDuration("action_http_get_request");){
            objectRange = (ResponseInputStream)this.getStoreContext().getInvoker().retryUntranslated("GET Ranged Object " + key, true, () -> this.getS3Client().getObject(request));
        }
        return objectRange;
    }

    @Override
    public Map.Entry<Duration, Optional<DeleteObjectResponse>> deleteObject(DeleteObjectRequest request) throws SdkException {
        String key = request.key();
        this.blockRootDelete(key);
        DurationInfo d = new DurationInfo(LOG, false, "deleting %s", new Object[]{key});
        try {
            DeleteObjectResponse response = (DeleteObjectResponse)this.invoker.retryUntranslated(String.format("Delete %s:/%s", this.bucket, key), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_DELETE_REQUEST.getSymbol(), () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS);
                Duration durationToAcquireWriteCapacity = this.acquireWriteCapacity(1);
                this.instrumentation.recordDuration(Statistic.STORE_IO_RATE_LIMITED, true, durationToAcquireWriteCapacity);
                return this.getS3Client().deleteObject(request);
            }));
            d.close();
            return Tuples.pair((Object)d.asDuration(), Optional.of(response));
        }
        catch (AwsServiceException ase) {
            if (!ErrorTranslation.isObjectNotFound(ase)) {
                throw ase;
            }
            d.close();
            return Tuples.pair((Object)d.asDuration(), Optional.empty());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody body, @Nullable DurationTrackerFactory trackerFactory) throws AwsServiceException, UncheckedIOException {
        long len = request.contentLength();
        this.incrementPutStartStatistics(len);
        try {
            UploadPartResponse uploadPartResponse = (UploadPartResponse)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.nonNullDurationTrackerFactory(trackerFactory), (String)Statistic.MULTIPART_UPLOAD_PART_PUT.getSymbol(), () -> this.getS3Client().uploadPart(request, body));
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResponse;
        }
        catch (AwsServiceException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    @Override
    public UploadInfo putObject(PutObjectRequest putObjectRequest, File file, ProgressableProgressListener listener) throws IOException {
        long len = S3AUtils.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {} via transfer manager ", (Object)len, (Object)putObjectRequest.key());
        this.incrementPutStartStatistics(len);
        FileUpload upload = this.getOrCreateTransferManager().uploadFile((UploadFileRequest)UploadFileRequest.builder().putObjectRequest(putObjectRequest).source(file).addTransferListener((TransferListener)listener).build());
        return new UploadInfo(upload, len);
    }

    @Override
    public CompletedFileUpload waitForUploadCompletion(String key, UploadInfo uploadInfo) throws IOException {
        FileUpload upload = uploadInfo.getFileUpload();
        try {
            CompletedFileUpload result = (CompletedFileUpload)upload.completionFuture().join();
            this.incrementPutCompletedStatistics(true, uploadInfo.getLength());
            return result;
        }
        catch (CompletionException e) {
            LOG.info("Interrupted: aborting upload");
            this.incrementPutCompletedStatistics(false, uploadInfo.getLength());
            throw S3AUtils.extractException("upload", key, e);
        }
    }

    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return this.getS3Client().completeMultipartUpload(request);
    }

    @Override
    public LocalDirAllocator getDirectoryAllocator() {
        return this.directoryAllocator;
    }

    @Override
    public File createTemporaryFileForWriting(String pathStr, long size, Configuration conf) throws IOException {
        Objects.requireNonNull(this.directoryAllocator, "directory allocator not initialized");
        Path path = this.directoryAllocator.getLocalPathForWrite(pathStr, size, conf);
        File dir = new File(path.getParent().toUri().getPath());
        String prefix = path.getName();
        return File.createTempFile(prefix, null, dir);
    }

    private void finishStreamFactoryInit() throws IOException {
        Preconditions.checkState((boolean)this.isInState(Service.STATE.INITED), (String)"Store is in wrong state: %s", (Object[])new Object[]{this.getServiceState()});
        Preconditions.checkState((boolean)this.clientManager.isInState(Service.STATE.INITED), (String)"Client Manager is in wrong state: %s", (Object[])new Object[]{this.clientManager.getServiceState()});
        this.objectInputStreamFactory.bind(new FactoryBindingParameters(new FactoryCallbacks()));
    }

    @Override
    public ObjectInputStream readObject(ObjectReadParameters parameters) throws IOException {
        parameters.withDirectoryAllocator(this.getDirectoryAllocator());
        return this.objectInputStreamFactory.readObject(parameters.validate());
    }

    @Override
    public StreamFactoryRequirements factoryRequirements() {
        return this.objectInputStreamFactory.factoryRequirements();
    }

    @Override
    public void bind(FactoryBindingParameters factoryBindingParameters) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InputStreamType streamType() {
        return this.objectInputStreamFactory.streamType();
    }

    private class FactoryCallbacks
    implements ObjectInputStreamFactory.StreamFactoryCallbacks {
        private FactoryCallbacks() {
        }

        @Override
        public S3AsyncClient getOrCreateAsyncClient(boolean requireCRT) throws IOException {
            LOG.debug("Stream factory requested async client");
            return S3AStoreImpl.this.clientManager().getOrCreateAsyncClient();
        }

        @Override
        public void incrementFactoryStatistic(Statistic statistic) {
            S3AStoreImpl.this.incrementStatistic(statistic);
        }
    }
}

