/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.StaticMapping;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultBlockPlacementPolicy {
    private static final short REPLICATION_FACTOR = 3;
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private MiniDFSCluster cluster = null;
    private NamenodeProtocols nameNodeRpc = null;
    private FSNamesystem namesystem = null;
    private PermissionStatus perm = null;

    @Before
    public void setup() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] racks = new String[]{"/RACK0", "/RACK0", "/RACK2", "/RACK3", "/RACK2"};
        String[] hosts = new String[]{"/host0", "/host1", "/host2", "/host3", "/host4"};
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).racks(racks).hosts(hosts).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        this.perm = new PermissionStatus("TestDefaultBlockPlacementPolicy", null, FsPermission.getDefault());
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testLocalRackPlacement() throws Exception {
        String clientMachine = "client.foo.com";
        String clientRack = "/RACK2";
        StaticMapping.addNodeToRack((String)clientMachine, (String)clientRack);
        this.testPlacement(clientMachine, clientRack, true);
    }

    @Test
    public void testLocalStoragePlacement() throws Exception {
        String clientMachine = "/host3";
        this.testPlacement(clientMachine, "/RACK3", true);
    }

    @Test
    public void testNonLocalRackPlacement() throws Exception {
        String clientMachine = "/host0";
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.CREATE);
        flags.add(CreateFlag.NO_LOCAL_RACK);
        HdfsFileStatus fileStatus = this.namesystem.startFile("/file", this.perm, clientMachine, clientMachine, flags, true, (short)3, 1024L, null, null, null, false);
        LocatedBlock locatedBlock = this.nameNodeRpc.addBlock("/file", clientMachine, null, null, fileStatus.getFileId(), null, EnumSet.of(AddBlockFlag.NO_LOCAL_RACK));
        Assert.assertTrue((locatedBlock.getLocations()[0].getNetworkLocation() != "/RACK0" ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"/RACK0", (Object)locatedBlock.getLocations()[0].getNetworkLocation());
        Assert.assertNotEquals((Object)"/RACK0", (Object)locatedBlock.getLocations()[1].getNetworkLocation());
        Assert.assertNotEquals((Object)"/RACK0", (Object)locatedBlock.getLocations()[2].getNetworkLocation());
    }

    @Test
    public void testPlacementWithDFSNetworkTopology() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] racks = new String[]{"/RACK0", "/RACK0", "/RACK2", "/RACK3", "/RACK2"};
        String[] hosts = new String[]{"/host0", "/host1", "/host2", "/host3", "/host4"};
        conf.setBoolean("dfs.use.dfs.network.topology", true);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).racks(racks).hosts(hosts).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        DatanodeManager dm = this.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertTrue((boolean)(dm.getNetworkTopology() instanceof DFSNetworkTopology));
        String clientMachine = "/host3";
        String clientRack = "/RACK3";
        String src = "/test";
        HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, (short)3, 1024L, null, null, null, false);
        LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
        Assert.assertEquals((String)"Block should be allocated sufficient locations", (long)3L, (long)locatedBlock.getLocations().length);
        Assert.assertEquals((String)"First datanode should be rack local", (Object)clientRack, (Object)locatedBlock.getLocations()[0].getNetworkLocation());
        this.nameNodeRpc.abandonBlock(locatedBlock.getBlock(), fileStatus.getFileId(), src, clientMachine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlacementWithLocalRackNodesDecommissioned() throws Exception {
        String clientMachine = "client.foo.com";
        String clientRack = "/RACK3";
        StaticMapping.addNodeToRack((String)clientMachine, (String)clientRack);
        DatanodeManager dnm = this.namesystem.getBlockManager().getDatanodeManager();
        DatanodeDescriptor dnd3 = dnm.getDatanode(this.cluster.getDataNodes().get(3).getDatanodeId());
        Assert.assertEquals((Object)dnd3.getNetworkLocation(), (Object)clientRack);
        dnm.getDatanodeAdminManager().startDecommission(dnd3);
        try {
            this.testPlacement(clientMachine, clientRack, false);
        }
        finally {
            dnm.getDatanodeAdminManager().stopDecommission(dnd3);
        }
    }

    @Test
    public void testRandomRackSelectionForRemoteClient() throws Exception {
        String clientMachine = "client.foo.com";
        this.testPlacement(clientMachine, null, true);
    }

    private void testPlacement(String clientMachine, String clientRack, boolean hasBlockReplicaOnRack) throws IOException {
        for (int i = 0; i < 5; ++i) {
            String src = "/test-" + i;
            HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, (short)3, 1024L, null, null, null, false);
            LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
            Assert.assertEquals((String)"Block should be allocated sufficient locations", (long)3L, (long)locatedBlock.getLocations().length);
            if (clientRack != null) {
                if (hasBlockReplicaOnRack) {
                    Assert.assertEquals((String)"First datanode should be rack local", (Object)clientRack, (Object)locatedBlock.getLocations()[0].getNetworkLocation());
                } else {
                    for (DatanodeInfoWithStorage dni : locatedBlock.getLocations()) {
                        Assert.assertNotEquals((Object)clientRack, (Object)dni.getNetworkLocation());
                    }
                }
            }
            this.nameNodeRpc.abandonBlock(locatedBlock.getBlock(), fileStatus.getFileId(), src, clientMachine);
        }
    }
}

