/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.FileStatus;

public final class ListUtils {
    private ListUtils() {
    }

    public static List<FileStatus> getUniqueListResult(List<FileStatus> originalList) {
        if (originalList == null || originalList.isEmpty()) {
            return originalList;
        }
        TreeMap<String, FileStatus> nameToEntryMap = new TreeMap<String, FileStatus>();
        String prefix = null;
        ArrayList<FileStatus> rectifiedFileStatusList = new ArrayList<FileStatus>();
        for (FileStatus current : originalList) {
            String fileName = current.getPath().getName();
            if (prefix == null || !fileName.startsWith(prefix)) {
                prefix = fileName;
                nameToEntryMap.clear();
            }
            if (nameToEntryMap.containsKey(fileName)) continue;
            nameToEntryMap.put(fileName, current);
            rectifiedFileStatusList.add(current);
        }
        return rectifiedFileStatusList;
    }
}

