/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.enums;

public enum RetryValue {
    ONE("1"),
    TWO("2"),
    THREE("3"),
    FOUR("4"),
    FIVE_FIFTEEN("5_15"),
    FIFTEEN_TWENTY_FIVE("15_25"),
    TWENTY_FIVE_AND_ABOVE("25AndAbove");

    private static final int FIVE = 5;
    private static final int FIFTEEN = 15;
    private static final int TWENTY_FIVE = 25;
    private final String value;

    private RetryValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static RetryValue getRetryValue(int retryCount) {
        if (retryCount == 1) {
            return ONE;
        }
        if (retryCount == 2) {
            return TWO;
        }
        if (retryCount == 3) {
            return THREE;
        }
        if (retryCount == 4) {
            return FOUR;
        }
        if (retryCount >= 5 && retryCount < 15) {
            return FIVE_FIFTEEN;
        }
        if (retryCount >= 15 && retryCount < 25) {
            return FIFTEEN_TWENTY_FIVE;
        }
        return TWENTY_FIVE_AND_ABOVE;
    }
}

