/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedureScheduler;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BalanceJob<T extends BalanceProcedure>
implements Writable {
    private String id;
    private BalanceProcedureScheduler scheduler;
    private volatile boolean jobDone = false;
    private Exception error;
    public static final Logger LOG = LoggerFactory.getLogger(BalanceJob.class);
    private Map<String, T> procedureTable = new HashMap<String, T>();
    private T firstProcedure;
    private T curProcedure;
    private T lastProcedure;
    private boolean removeAfterDone;
    static final String NEXT_PROCEDURE_NONE = "NONE";
    private static Set<String> reservedNames = new HashSet<String>();

    private BalanceJob(Iterable<T> procedures, boolean remove) throws IOException {
        for (BalanceProcedure p : procedures) {
            String taskName = p.name();
            if (reservedNames.contains(taskName)) {
                throw new IOException(taskName + " is reserved.");
            }
            this.procedureTable.put(p.name(), p);
            if (this.firstProcedure != null) continue;
            this.firstProcedure = p;
        }
        this.removeAfterDone = remove;
        this.lastProcedure = null;
        this.curProcedure = this.firstProcedure;
    }

    public void execute() {
        boolean quit = false;
        try {
            while (!this.jobDone && !quit && this.scheduler.isRunning()) {
                if (this.curProcedure == null) {
                    this.finish(null);
                    quit = true;
                    continue;
                }
                if (this.curProcedure == this.firstProcedure || this.lastProcedure != this.curProcedure) {
                    LOG.info("Start procedure {}, last procedure is {}", (Object)((BalanceProcedure)this.curProcedure).name(), this.lastProcedure == null ? null : ((BalanceProcedure)this.lastProcedure).name());
                }
                if (((BalanceProcedure)this.curProcedure).execute()) {
                    this.lastProcedure = this.curProcedure;
                    this.curProcedure = this.next();
                }
                if (this.scheduler.writeJournal(this)) continue;
                quit = true;
                LOG.debug("Write journal failed. Quit and wait for recovery.");
            }
        }
        catch (BalanceProcedure.RetryException tre) {
            this.scheduler.delay(this, ((BalanceProcedure)this.curProcedure).delayMillisBeforeRetry());
        }
        catch (Exception e) {
            this.finish(e);
        }
        catch (Throwable t) {
            IOException err = new IOException("Got throwable error.", t);
            this.finish(err);
        }
    }

    private T next() {
        if (this.curProcedure == null) {
            return this.firstProcedure;
        }
        return (T)((BalanceProcedure)this.procedureTable.get(((BalanceProcedure)this.curProcedure).nextProcedure()));
    }

    private synchronized void finish(Exception exception) {
        assert (!this.jobDone);
        if (this.scheduler.jobDone(this)) {
            this.jobDone = true;
            this.error = exception;
            this.notifyAll();
        }
    }

    void setScheduler(BalanceProcedureScheduler scheduler) {
        this.scheduler = scheduler;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    public boolean shouldRemoveAfterDone() {
        return this.removeAfterDone;
    }

    @VisibleForTesting
    void setLastProcedure(T lastProcedure) {
        this.lastProcedure = lastProcedure;
    }

    @VisibleForTesting
    void setCurrentProcedure(T currentProcedure) {
        this.curProcedure = currentProcedure;
    }

    public boolean isJobDone() {
        return this.jobDone;
    }

    public synchronized void waitJobDone() throws InterruptedException {
        while (!this.jobDone) {
            this.wait();
        }
    }

    public Exception getError() {
        return this.error;
    }

    public void write(DataOutput out) throws IOException {
        if (this.id == null) {
            throw new IOException("BalanceJob with id=null can not be serialized.");
        }
        Text.writeString((DataOutput)out, (String)this.id);
        int taskTableSize = this.procedureTable.size();
        out.writeInt(taskTableSize);
        for (BalanceProcedure p : this.procedureTable.values()) {
            Text.writeString((DataOutput)out, (String)p.getClass().getName());
            p.write(out);
        }
        if (this.firstProcedure != null) {
            Text.writeString((DataOutput)out, (String)((BalanceProcedure)this.firstProcedure).name());
        } else {
            Text.writeString((DataOutput)out, (String)NEXT_PROCEDURE_NONE);
        }
        if (this.curProcedure != null) {
            Text.writeString((DataOutput)out, (String)((BalanceProcedure)this.curProcedure).name());
        } else {
            Text.writeString((DataOutput)out, (String)NEXT_PROCEDURE_NONE);
        }
        if (this.lastProcedure != null) {
            Text.writeString((DataOutput)out, (String)((BalanceProcedure)this.lastProcedure).name());
        } else {
            Text.writeString((DataOutput)out, (String)NEXT_PROCEDURE_NONE);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.id = Text.readString((DataInput)in);
        this.procedureTable = new HashMap<String, T>();
        int taskTableSize = in.readInt();
        for (int i = 0; i < taskTableSize; ++i) {
            String className = Text.readString((DataInput)in);
            try {
                BalanceProcedure p = (BalanceProcedure)ReflectionUtils.newInstance(Class.forName(className), null);
                p.readFields(in);
                this.procedureTable.put(p.name(), p);
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed reading Procedure.", (Throwable)e);
                throw new IOException(e);
            }
        }
        String firstProcedureName = Text.readString((DataInput)in);
        this.firstProcedure = firstProcedureName.equals(NEXT_PROCEDURE_NONE) ? null : (BalanceProcedure)this.procedureTable.get(firstProcedureName);
        String currentProcedureName = Text.readString((DataInput)in);
        this.curProcedure = currentProcedureName.equals(NEXT_PROCEDURE_NONE) ? null : (BalanceProcedure)this.procedureTable.get(currentProcedureName);
        String lastProcedureName = Text.readString((DataInput)in);
        this.lastProcedure = lastProcedureName.equals(NEXT_PROCEDURE_NONE) ? null : (BalanceProcedure)this.procedureTable.get(lastProcedureName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BalanceJob bj = (BalanceJob)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)bj.id).append(this.procedureTable, bj.procedureTable).append(this.firstProcedure, bj.firstProcedure).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append(this.procedureTable).toHashCode();
    }

    public String toString() {
        return "{jobId=" + this.id + "}";
    }

    public String getDetailMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("id=").append(this.id);
        if (this.firstProcedure != null) {
            builder.append(",firstProcedure=").append(this.firstProcedure);
        }
        if (this.curProcedure != null) {
            builder.append(",currentProcedure=").append(this.curProcedure);
        }
        builder.append(",jobDone=").append(this.jobDone);
        if (this.error != null) {
            builder.append(",error=").append(this.error.getMessage());
        }
        return builder.toString();
    }

    boolean isSchedulerShutdown() {
        return !this.scheduler.isRunning();
    }

    @VisibleForTesting
    Map<String, T> getProcedureTable() {
        return this.procedureTable;
    }

    @VisibleForTesting
    T getCurProcedure() {
        return this.curProcedure;
    }

    static {
        reservedNames.add(NEXT_PROCEDURE_NONE);
    }

    public static class Builder<T extends BalanceProcedure> {
        private List<T> procedures = new ArrayList<T>();
        private boolean removeAfterDone = false;

        public Builder nextProcedure(T procedure) {
            int size = this.procedures.size();
            if (size > 0) {
                ((BalanceProcedure)this.procedures.get(size - 1)).setNextProcedure(((BalanceProcedure)procedure).name());
            }
            ((BalanceProcedure)procedure).setNextProcedure(BalanceJob.NEXT_PROCEDURE_NONE);
            this.procedures.add(procedure);
            return this;
        }

        public Builder removeAfterDone(boolean remove) {
            this.removeAfterDone = remove;
            return this;
        }

        public BalanceJob build() throws IOException {
            BalanceJob job = new BalanceJob(this.procedures, this.removeAfterDone);
            for (BalanceProcedure p : this.procedures) {
                p.setJob(job);
            }
            return job;
        }
    }
}

