/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.ojalgo.type.CalendarDateUnit;

public class ScheduleBuilder {
    private final TimerTask myTask;
    private Date myStartDate = null;
    private int myRepetitionMeassure;
    private CalendarDateUnit myRepetitionUnit = null;

    public ScheduleBuilder(TimerTask aTask) {
        this.myTask = aTask;
    }

    private ScheduleBuilder() {
        this(null);
    }

    public ScheduleBuilder repetition(int aRepetitionMeassure, CalendarDateUnit aRepetitionUnit) {
        this.myRepetitionMeassure = aRepetitionMeassure;
        this.myRepetitionUnit = aRepetitionUnit;
        return this;
    }

    public void schedule(Timer aTimer) {
        if (this.myStartDate != null) {
            if (this.myRepetitionUnit != null) {
                aTimer.scheduleAtFixedRate(this.myTask, this.myStartDate, (long)this.myRepetitionMeassure * this.myRepetitionUnit.size());
            } else {
                aTimer.schedule(this.myTask, this.myStartDate);
            }
        } else if (this.myRepetitionUnit != null) {
            aTimer.scheduleAtFixedRate(this.myTask, new Date(), (long)this.myRepetitionMeassure * this.myRepetitionUnit.size());
        } else {
            aTimer.schedule(this.myTask, new Date());
        }
    }

    public ScheduleBuilder start(Date aStartDate) {
        this.myStartDate = new Date(aStartDate.getTime());
        return this;
    }

    public ScheduleBuilder start(int aDelayMeassure, CalendarDateUnit aDelayUnit) {
        this.myStartDate = new Date(System.currentTimeMillis() + (long)aDelayMeassure * aDelayUnit.size());
        return this;
    }
}

