/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import org.ojalgo.access.AccessScalar;
import org.ojalgo.algebra.Field;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.type.context.NumberContext;

public interface Scalar<N extends Number>
extends AccessScalar<N>,
Field<Scalar<N>>,
NormedVectorSpace<Scalar<N>, N>,
ScalarOperation.Addition<Scalar<N>, N>,
ScalarOperation.Division<Scalar<N>, N>,
ScalarOperation.Subtraction<Scalar<N>, N>,
Comparable<N> {
    @Override
    default public Scalar<N> add(Scalar<N> addend) {
        return (Scalar)this.add(addend.getNumber());
    }

    @Override
    default public Scalar<N> divide(Scalar<N> divisor) {
        return (Scalar)this.divide(divisor.getNumber());
    }

    public boolean isAbsolute();

    @Override
    default public Scalar<N> multiply(Scalar<N> multiplicand) {
        return (Scalar)this.multiply(multiplicand.getNumber());
    }

    @Override
    default public Scalar<N> subtract(Scalar<N> subtrahend) {
        return (Scalar)this.subtract(subtrahend.getNumber());
    }

    public BigDecimal toBigDecimal();

    default public String toPlainString(NumberContext context) {
        return context.enforce(this.toBigDecimal()).toPlainString();
    }

    public String toString(NumberContext var1);

    public static interface Factory<N extends Number> {
        public N cast(double var1);

        public N cast(Number var1);

        public Scalar<N> convert(double var1);

        public Scalar<N> convert(Number var1);

        public Scalar<N> one();

        public Scalar<N> zero();
    }
}

