/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.Exponential;
import org.ojalgo.random.Poisson;
import org.ojalgo.random.process.AbstractProcess;

public final class PoissonProcess
extends AbstractProcess<Poisson> {
    private static final Poisson GENERATOR = new Poisson();
    private final double myRate;

    protected PoissonProcess(double rate) {
        this.setValue(PrimitiveMath.ZERO);
        this.myRate = rate;
    }

    @Override
    public Poisson getDistribution(double evaluationPoint) {
        return new Poisson(this.myRate * evaluationPoint);
    }

    public Exponential getTimeBetweenConsecutiveEvents() {
        return new Exponential(this.myRate);
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double retVal = currentValue + this.myRate * stepSize * normalisedRandomIncrement;
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.myRate * stepSize;
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        throw new UnsupportedOperationException();
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveFunction.SQRT.invoke(this.myRate * stepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        throw new UnsupportedOperationException();
    }

    @Override
    double getVariance(double stepSize) {
        return this.myRate * stepSize;
    }
}

