/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractDiscrete;
import org.ojalgo.random.RandomUtils;

public class Binomial
extends AbstractDiscrete {
    private static final long serialVersionUID = -3146302867013736326L;
    private final int myCount;
    private final double myProbability;

    public Binomial() {
        this(1, PrimitiveMath.HALF);
    }

    public Binomial(int aCount, double aProbability) {
        this.myCount = aCount;
        this.myProbability = aProbability;
    }

    @Override
    public double getExpected() {
        return (double)this.myCount * this.myProbability;
    }

    @Override
    public double getProbability(int value) {
        return (double)RandomUtils.subsets(this.myCount, value) * PrimitiveFunction.POW.invoke(this.myProbability, value) * PrimitiveFunction.POW.invoke(PrimitiveMath.ONE - this.myProbability, this.myCount - value);
    }

    @Override
    public double getVariance() {
        return (double)this.myCount * this.myProbability * (PrimitiveMath.ONE - this.myProbability);
    }

    @Override
    protected double generate() {
        int retVal = 0;
        for (int i = 0; i < this.myCount; ++i) {
            retVal = (int)((double)retVal + (this.myProbability + this.random().nextDouble()));
        }
        return retVal;
    }
}

