/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;

final class Tableau
implements Access2D<Double>,
Mutate2D {
    private double myInfeasibility;
    private final long myNumberOfConstraints;
    private final long myNumberOfVariables;
    private double myObjective;
    private final Primitive64Array myPhase1Weights;
    private final Primitive64Array myRHS;
    private final SparseArray<Double>[] myRows;
    private final Primitive64Array myWeights;

    Tableau(int numberOfConstraints, int numberOfVariables) {
        this.myNumberOfConstraints = numberOfConstraints;
        this.myNumberOfVariables = numberOfVariables;
        this.myRows = new SparseArray[numberOfConstraints];
        for (int r = 0; r < numberOfConstraints; ++r) {
            this.myRows[r] = ((SparseArray.SparseFactory)SparseArray.factory(Primitive64Array.FACTORY, this.myNumberOfVariables).initial(4L)).make();
        }
        this.myRHS = Primitive64Array.make((int)this.myNumberOfConstraints);
        this.myWeights = Primitive64Array.make((int)this.myNumberOfVariables);
        this.myPhase1Weights = Primitive64Array.make((int)this.myNumberOfVariables);
    }

    @Override
    public void add(long row, long col, double addend) {
        if (row < this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                this.myRows[(int)row].add(col, addend);
            } else {
                this.myRHS.add(row, addend);
            }
        } else if (row == this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                this.myWeights.add(col, addend);
            } else {
                this.myObjective += addend;
            }
        } else if (col < this.myNumberOfVariables) {
            this.myPhase1Weights.add(col, addend);
        } else {
            this.myInfeasibility += addend;
        }
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.add(row, col, addend.doubleValue());
    }

    @Override
    public long countColumns() {
        return this.myNumberOfVariables + 1L;
    }

    public long countConstraints() {
        return this.myNumberOfConstraints;
    }

    @Override
    public long countRows() {
        return this.myNumberOfConstraints + 2L;
    }

    public long countVariables() {
        return this.myNumberOfVariables;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row < this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                return this.myRows[(int)row].doubleValue(col);
            }
            return this.myRHS.doubleValue(row);
        }
        if (row == this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                return this.myWeights.doubleValue(col);
            }
            return this.myObjective;
        }
        if (col < this.myNumberOfVariables) {
            return this.myPhase1Weights.doubleValue(col);
        }
        return this.myInfeasibility;
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    @Override
    public void set(long row, long col, double value) {
        if (row < this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                this.myRows[(int)row].set(col, value);
            } else {
                this.myRHS.set(row, value);
            }
        } else if (row == this.myNumberOfConstraints) {
            if (col < this.myNumberOfVariables) {
                this.myWeights.set(col, value);
            } else {
                this.myObjective = value;
            }
        } else if (col < this.myNumberOfVariables) {
            this.myPhase1Weights.set(col, value);
        } else {
            this.myInfeasibility = value;
        }
    }

    @Override
    public void set(long row, long col, Number value) {
        this.set(row, col, value.doubleValue());
    }

    double getInfeasibility() {
        return this.myInfeasibility;
    }

    Primitive64Array getRHS() {
        return this.myRHS;
    }

    void pivot(int row, int col) {
        double tmpVal;
        SparseArray<Double> tmpY;
        int i;
        UnaryFunction<double> tmpModifier;
        SparseArray<Double> tmpPivotRow = this.myRows[row];
        double tmpPivotElement = tmpPivotRow.doubleValue(col);
        if (PrimitiveFunction.ABS.invoke(tmpPivotElement) < PrimitiveMath.ONE) {
            tmpModifier = PrimitiveFunction.DIVIDE.second(tmpPivotElement);
            tmpPivotRow.modifyAll(tmpModifier);
            this.myRHS.modifyOne((long)row, tmpModifier);
        } else if (tmpPivotElement != PrimitiveMath.ONE) {
            tmpModifier = PrimitiveFunction.MULTIPLY.second(PrimitiveMath.ONE / tmpPivotElement);
            tmpPivotRow.modifyAll(tmpModifier);
            this.myRHS.modifyOne((long)row, tmpModifier);
        }
        double tmpPivotRHS = this.myRHS.doubleValue((long)row);
        for (i = 0; i < row; ++i) {
            tmpY = this.myRows[i];
            tmpVal = -tmpY.doubleValue(col);
            tmpPivotRow.axpy(tmpVal, tmpY);
            this.myRHS.add((long)i, tmpVal * tmpPivotRHS);
        }
        for (i = row + 1; i < this.myRows.length; ++i) {
            tmpY = this.myRows[i];
            tmpVal = -tmpY.doubleValue(col);
            tmpPivotRow.axpy(tmpVal, tmpY);
            this.myRHS.add((long)i, tmpVal * tmpPivotRHS);
        }
        tmpVal = -this.myWeights.doubleValue((long)col);
        tmpPivotRow.axpy(tmpVal, this.myWeights);
        this.myObjective += tmpVal * tmpPivotRHS;
        tmpVal = -this.myPhase1Weights.doubleValue((long)col);
        tmpPivotRow.axpy(tmpVal, this.myPhase1Weights);
        this.myInfeasibility += tmpVal * tmpPivotRHS;
    }
}

