/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.io.Serializable;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixError;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

abstract class AbstractMatrix<N extends Number, I extends BasicMatrix>
implements BasicMatrix,
Serializable {
    private transient MatrixDecomposition<N> myDecomposition = null;
    private transient int myHashCode = 0;
    private transient Boolean myHermitian = null;
    private final MatrixStore<N> myStore;
    private transient Boolean mySymmetric = null;

    private AbstractMatrix() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    AbstractMatrix(MatrixStore<N> store) {
        this.myStore = store;
    }

    @Override
    public I add(BasicMatrix addend) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, addend);
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(addend);
        retVal.modifyMatching(this.myStore, this.myStore.physical().function().add());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I add(double scalarAddend) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarAddend);
        retVal.modifyAll(this.myStore.physical().function().add().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    public I add(int row, int col, Access2D<?> addend) {
        Object tmpDiff = this.cast(addend).get();
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().superimpose(row, col, (MatrixStore<N>)tmpDiff).get());
    }

    @Override
    public I add(Number scalarAddend) {
        PhysicalStore.Factory tmpPhysical = this.myStore.physical();
        PhysicalStore retVal = (PhysicalStore)tmpPhysical.copy(this.myStore);
        Object tmpRight = tmpPhysical.scalar().cast(scalarAddend);
        retVal.modifyAll(tmpPhysical.function().add().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public N aggregateColumn(long row, long col, Aggregator aggregator) {
        return this.myStore.aggregateColumn(row, col, aggregator);
    }

    @Override
    public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        return this.myStore.aggregateDiagonal(row, col, aggregator);
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        return this.myStore.aggregateRange(first, limit, aggregator);
    }

    @Override
    public N aggregateRow(long row, long col, Aggregator aggregator) {
        return this.myStore.aggregateRow(row, col, aggregator);
    }

    @Override
    public I conjugate() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.conjugate());
    }

    public BasicMatrix.Builder<I> copy() {
        return this.getFactory().wrap(this.myStore.copy());
    }

    @Override
    public long count() {
        return this.myStore.count();
    }

    @Override
    public long countColumns() {
        return this.myStore.countColumns();
    }

    @Override
    public long countRows() {
        return this.myStore.countRows();
    }

    @Override
    public I divide(double scalarDivisor) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarDivisor);
        retVal.modifyAll(this.myStore.physical().function().divide().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I divide(Number scalarDivisor) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarDivisor);
        retVal.modifyAll(this.myStore.physical().function().divide().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    public I divideElements(Access2D<?> divisor) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, divisor);
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(divisor);
        retVal.modifyMatching(this.myStore, this.myStore.physical().function().divide());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public double doubleValue(long index) {
        return this.myStore.doubleValue(index);
    }

    @Override
    public double doubleValue(long i, long j) {
        return this.myStore.doubleValue(i, j);
    }

    public I enforce(NumberContext context) {
        PhysicalStore tmpCopy = this.myStore.copy();
        tmpCopy.modifyAll(this.myStore.physical().function().enforce(context));
        return this.getFactory().instantiate(tmpCopy);
    }

    @Override
    public boolean equals(Access2D<?> aMtrx, NumberContext aCntxt) {
        return AccessUtils.equals(this.myStore, aMtrx, aCntxt);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Access2D) {
            return this.equals((Access2D)obj, NumberContext.getGeneral(6));
        }
        return super.equals(obj);
    }

    @Override
    public void flushCache() {
        this.myHashCode = 0;
        if (this.myDecomposition != null) {
            this.myDecomposition.reset();
            this.myDecomposition = null;
        }
        this.myHermitian = null;
        this.mySymmetric = null;
    }

    @Override
    public N get(long index) {
        return this.myStore.get(index);
    }

    @Override
    public N get(long aRow, long aColumn) {
        return this.myStore.get(aRow, aColumn);
    }

    public I getColumnsRange(int first, int limit) {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().limits((int)this.myStore.countRows(), limit).offsets(0, first).get());
    }

    public Scalar<N> getCondition() {
        return this.myStore.physical().scalar().convert(this.getComputedSingularValue().getCondition());
    }

    public Scalar<N> getDeterminant() {
        Number tmpDeterminant = null;
        if (this.myDecomposition != null && this.myDecomposition instanceof MatrixDecomposition.Determinant && ((MatrixDecomposition.Determinant)this.myDecomposition).isComputed()) {
            tmpDeterminant = (Number)((MatrixDecomposition.Determinant)this.myDecomposition).getDeterminant();
        } else {
            DeterminantTask<N> tmpTask = this.getDeterminantTask(this.myStore);
            if (tmpTask instanceof MatrixDecomposition.Determinant) {
                this.myDecomposition = (MatrixDecomposition.Determinant)tmpTask;
            }
            tmpDeterminant = (Number)tmpTask.calculateDeterminant(this.myStore);
        }
        return this.myStore.physical().scalar().convert(tmpDeterminant);
    }

    @Override
    public List<ComplexNumber> getEigenvalues() {
        return this.getComputedEigenvalue().getEigenvalues();
    }

    public Scalar<N> getFrobeniusNorm() {
        return this.myStore.physical().scalar().convert(BasicMatrix.calculateFrobeniusNorm(this));
    }

    public Scalar<N> getInfinityNorm() {
        return this.myStore.physical().scalar().convert(BasicMatrix.calculateInfinityNorm(this));
    }

    public Scalar<N> getKyFanNorm(int k) {
        return this.myStore.physical().scalar().convert(this.getComputedSingularValue().getKyFanNorm(k));
    }

    public Scalar<N> getOneNorm() {
        return this.myStore.physical().scalar().convert(BasicMatrix.calculateOneNorm(this));
    }

    @Deprecated
    public Scalar<N> getOperatorNorm() {
        return this.myStore.physical().scalar().convert(this.getComputedSingularValue().getOperatorNorm());
    }

    @Override
    public int getRank() {
        return this.getComputedSingularValue().getRank();
    }

    public I getRowsRange(int first, int limit) {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().limits(limit, (int)this.myStore.countColumns()).offsets(first, 0).get());
    }

    public List<Double> getSingularValues() {
        return this.getComputedSingularValue().getSingularValues();
    }

    public Scalar<N> getTrace() {
        AggregatorFunction tmpAggr = this.myStore.physical().aggregator().sum();
        this.myStore.visitDiagonal(0L, 0L, tmpAggr);
        return this.myStore.physical().scalar().convert((Number)tmpAggr.getNumber());
    }

    public Scalar<N> getTraceNorm() {
        return this.myStore.physical().scalar().convert(this.getComputedSingularValue().getTraceNorm());
    }

    @Deprecated
    public Scalar<N> getVectorNorm(int degree) {
        switch (degree) {
            case 0: {
                return this.myStore.physical().scalar().convert((Number)this.myStore.aggregateAll(Aggregator.CARDINALITY));
            }
            case 1: {
                return this.myStore.physical().scalar().convert((Number)this.myStore.aggregateAll(Aggregator.NORM1));
            }
            case 2: {
                return this.myStore.physical().scalar().convert((Number)this.myStore.aggregateAll(Aggregator.NORM2));
            }
        }
        return this.myStore.physical().scalar().convert((Number)this.myStore.aggregateAll(Aggregator.LARGEST));
    }

    public int hashCode() {
        if (this.myHashCode == 0) {
            this.myHashCode = MatrixUtils.hashCode(this.myStore);
        }
        return this.myHashCode;
    }

    public I invert() {
        MatrixStore tmpInverse = null;
        if (this.myDecomposition != null && this.myDecomposition instanceof MatrixDecomposition.Solver && ((MatrixDecomposition.Solver)this.myDecomposition).isSolvable()) {
            tmpInverse = ((MatrixDecomposition.Solver)this.myDecomposition).getInverse();
        } else {
            InverterTask<N> tmpTask = this.getInverterTask(this.myStore);
            if (tmpTask instanceof MatrixDecomposition.Solver) {
                MatrixDecomposition.Solver tmpSolver;
                this.myDecomposition = tmpSolver = (MatrixDecomposition.Solver)tmpTask;
                tmpInverse = tmpSolver.compute(this.myStore) ? tmpSolver.getInverse() : null;
            } else {
                try {
                    tmpInverse = tmpTask.invert(this.myStore);
                }
                catch (TaskException xcptn) {
                    xcptn.printStackTrace();
                    tmpInverse = null;
                }
            }
        }
        return this.getFactory().instantiate(tmpInverse);
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return this.myStore.isAbsolute(row, col);
    }

    @Override
    public boolean isFullRank() {
        return (long)this.getRank() == Math.min(this.myStore.countRows(), this.myStore.countColumns());
    }

    @Override
    public boolean isHermitian() {
        if (this.myHermitian == null) {
            this.myHermitian = this.isSquare() && this.myStore.equals((MatrixStore<N>)this.myStore.conjugate(), NumberContext.getGeneral(6));
        }
        return this.myHermitian;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return this.myStore.isSmall(comparedTo);
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return this.myStore.isSmall(row, col, comparedTo);
    }

    @Override
    public boolean isSymmetric() {
        if (this.mySymmetric == null) {
            this.mySymmetric = this.isSquare() && this.myStore.equals((MatrixStore<N>)this.myStore.transpose(), NumberContext.getGeneral(6));
        }
        return this.mySymmetric;
    }

    public I mergeColumns(Access2D<?> belowRows) {
        MatrixError.throwIfNotEqualColumnDimensions(this.myStore, belowRows);
        Object tmpBelow = this.cast(belowRows).get();
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().below(new MatrixStore[]{tmpBelow}).get());
    }

    public I mergeRows(Access2D<?> rightColumns) {
        MatrixError.throwIfNotEqualRowDimensions(this.myStore, rightColumns);
        Object tmpRight = this.cast(rightColumns).get();
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().right(new MatrixStore[]{tmpRight}).get());
    }

    public I modify(UnaryFunction<? extends Number> modifier) {
        PhysicalStore<? extends Number> retVal = this.myStore.copy();
        retVal.modifyAll(modifier);
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I multiply(BasicMatrix multiplicand) {
        MatrixError.throwIfMultiplicationNotPossible(this.myStore, multiplicand);
        return this.getFactory().instantiate(this.myStore.multiply(this.cast(multiplicand).get()));
    }

    @Override
    public I multiply(double scalarMultiplicand) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarMultiplicand);
        retVal.modifyAll(this.myStore.physical().function().multiply().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I multiply(Number scalarMultiplicand) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarMultiplicand);
        retVal.modifyAll(this.myStore.physical().function().multiply().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    public I multiplyElements(Access2D<?> multiplicand) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, multiplicand);
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(multiplicand);
        retVal.modifyMatching(this.myStore, this.myStore.physical().function().multiply());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I negate() {
        PhysicalStore retVal = this.myStore.copy();
        retVal.modifyAll(this.myStore.physical().function().negate());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public double norm() {
        return this.myStore.norm();
    }

    public I selectColumns(int ... someCols) {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().column(someCols).get());
    }

    public I selectRows(int ... someRows) {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.logical().row(someRows).get());
    }

    @Override
    public I signum() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.signum());
    }

    public I solve(Access2D<?> rhs) {
        MatrixStore<N> tmpSolution = null;
        if (this.myDecomposition != null && this.myDecomposition instanceof MatrixDecomposition.Solver && ((MatrixDecomposition.Solver)this.myDecomposition).isSolvable()) {
            tmpSolution = ((MatrixDecomposition.Solver)this.myDecomposition).getSolution(this.cast(rhs));
        } else {
            SolverTask<N> tmpTask = this.getSolverTask(this.myStore, rhs);
            if (tmpTask instanceof MatrixDecomposition.Solver) {
                MatrixDecomposition.Solver tmpSolver;
                this.myDecomposition = tmpSolver = (MatrixDecomposition.Solver)tmpTask;
                tmpSolution = tmpSolver.compute(this.myStore) ? tmpSolver.getSolution(this.cast(rhs)) : null;
            } else {
                try {
                    tmpSolution = tmpTask.solve(this.myStore, rhs);
                }
                catch (TaskException xcptn) {
                    xcptn.printStackTrace();
                    tmpSolution = null;
                }
            }
        }
        return this.getFactory().instantiate(tmpSolution);
    }

    @Override
    public I subtract(BasicMatrix subtrahend) {
        MatrixError.throwIfNotEqualDimensions(this.myStore, subtrahend);
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(subtrahend);
        retVal.modifyMatching(this.myStore, this.myStore.physical().function().subtract());
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public BasicMatrix subtract(double scalarSubtrahend) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarSubtrahend);
        retVal.modifyAll(this.myStore.physical().function().subtract().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    @Override
    public I subtract(Number scalarSubtrahend) {
        PhysicalStore retVal = (PhysicalStore)this.myStore.physical().copy(this.myStore);
        Object tmpRight = this.myStore.physical().scalar().cast(scalarSubtrahend);
        retVal.modifyAll(this.myStore.physical().function().subtract().second(tmpRight));
        return this.getFactory().instantiate(retVal);
    }

    public Scalar<N> toScalar(long row, long col) {
        return this.myStore.toScalar(row, col);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public I transpose() {
        return this.getFactory().instantiate((MatrixStore<N>)this.myStore.transpose());
    }

    private final Eigenvalue<N> getComputedEigenvalue() {
        if (!this.isComputedEigenvalue()) {
            this.myDecomposition = Eigenvalue.make(this.myStore);
            this.myDecomposition.decompose(this.myStore);
        }
        return (Eigenvalue)this.myDecomposition;
    }

    private final SingularValue<N> getComputedSingularValue() {
        if (!this.isComputedSingularValue()) {
            this.myDecomposition = SingularValue.make(this.myStore);
            this.myDecomposition.decompose(this.myStore);
        }
        return (SingularValue)this.myDecomposition;
    }

    private boolean isComputedEigenvalue() {
        return this.myDecomposition != null && this.myDecomposition instanceof Eigenvalue && this.myDecomposition.isComputed();
    }

    private boolean isComputedSingularValue() {
        return this.myDecomposition != null && this.myDecomposition instanceof SingularValue && this.myDecomposition.isComputed();
    }

    abstract ElementsSupplier<N> cast(Access1D<?> var1);

    abstract DeterminantTask<N> getDeterminantTask(MatrixStore<N> var1);

    abstract MatrixFactory<N, I> getFactory();

    abstract InverterTask<N> getInverterTask(MatrixStore<N> var1);

    abstract SolverTask<N> getSolverTask(MatrixStore<N> var1, Access2D<?> var2);

    final MatrixStore<N> getStore() {
        return this.myStore;
    }
}

