/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import java.util.Arrays;
import java.util.TreeSet;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.machine.AbstractMachine;
import org.ojalgo.machine.BasicMachine;
import org.ojalgo.machine.VirtualMachine;

public final class Hardware
extends AbstractMachine
implements Comparable<Hardware> {
    public static final long CPU_CACHE_LINE_SIZE = 64L;
    public static final long OS_MEMORY_PAGE_SIZE = 4096L;
    public static final TreeSet<Hardware> PREDEFINED = new TreeSet();
    static final Hardware PPC__01 = new Hardware("ppc", new BasicMachine[]{new BasicMachine(0x50000000L, 1), new BasicMachine(524288L, 1), new BasicMachine(65536L, 1)});
    static final Hardware X86__01 = new Hardware("x86", new BasicMachine[]{new BasicMachine(0x40000000L, 1), new BasicMachine(0x100000L, 1), new BasicMachine(32768L, 1)});
    static final Hardware X86__02 = new Hardware("x86", new BasicMachine[]{new BasicMachine(0xE0000000L, 2), new BasicMachine(0x600000L, 2), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__02 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0xC0000000L, 2), new BasicMachine(0x400000L, 2), new BasicMachine(32768L, 1)});
    static final Hardware X86_64__04 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x200000000L, 4), new BasicMachine(0x300000L, 4), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__08 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x800000000L, 8), new BasicMachine(0x800000L, 8), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__12 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x300000000L, 12), new BasicMachine(0xC00000L, 12), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__16 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x300000000L, 16), new BasicMachine(0x800000L, 8), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__64 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x8000000000L, 64), new BasicMachine(0x800000L, 8), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    static final Hardware X86_64__96 = new Hardware("x86_64", new BasicMachine[]{new BasicMachine(0x8000000000L, 64), new BasicMachine(0x800000L, 12), new BasicMachine(262144L, 2), new BasicMachine(32768L, 2)});
    private final BasicMachine[] myLevels;

    public static Hardware makeSimple() {
        return Hardware.makeSimple(VirtualMachine.getArchitecture(), VirtualMachine.getMemory(), VirtualMachine.getThreads());
    }

    public static Hardware makeSimple(String systemArchitecture, long systemMemory, int systemThreads) {
        if (systemThreads > 8) {
            BasicMachine tmpL1Machine = new BasicMachine(32768L, 2);
            BasicMachine tmpL2Machine = new BasicMachine(262144L, tmpL1Machine.threads);
            BasicMachine tmpL3Machine = new BasicMachine(0x400000L, systemThreads / ((systemThreads + 7) / 8));
            BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
            return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL3Machine, tmpL2Machine, tmpL1Machine});
        }
        if (systemThreads >= 4) {
            BasicMachine tmpL1Machine = new BasicMachine(32768L, 2);
            BasicMachine tmpL2Machine = new BasicMachine(262144L, tmpL1Machine.threads);
            BasicMachine tmpL3Machine = new BasicMachine(0x300000L, systemThreads);
            BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
            return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL3Machine, tmpL2Machine, tmpL1Machine});
        }
        BasicMachine tmpL1Machine = new BasicMachine(32768L, 1);
        BasicMachine tmpL2Machine = new BasicMachine(0x200000L, tmpL1Machine.threads);
        BasicMachine tmpSystemMachine = new BasicMachine(systemMemory, systemThreads);
        return new Hardware(systemArchitecture, new BasicMachine[]{tmpSystemMachine, tmpL2Machine, tmpL1Machine});
    }

    public Hardware(String architecture, BasicMachine[] levels) {
        super(architecture, levels);
        if (levels.length < 2) {
            throw new IllegalArgumentException();
        }
        this.myLevels = ArrayUtils.copyOf(levels);
    }

    private Hardware(Hardware aHardware, Runtime aRuntime) {
        super(aHardware, aRuntime);
        this.myLevels = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    @Override
    public int compareTo(Hardware aReference) {
        if (this.units != aReference.units) {
            return this.units - aReference.units;
        }
        if (this.cache != aReference.cache) {
            return (int)(this.cache - aReference.cache);
        }
        if (this.cores != aReference.cores) {
            return this.cores - aReference.cores;
        }
        if (this.threads != aReference.threads) {
            return this.threads - aReference.threads;
        }
        if (this.memory != aReference.memory) {
            return (int)(this.memory - aReference.memory);
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Hardware)) {
            return false;
        }
        Hardware other = (Hardware)obj;
        return Arrays.equals(this.myLevels, other.myLevels);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.myLevels);
        return result;
    }

    public boolean isL2Specified() {
        return this.myLevels.length > 2;
    }

    public boolean isL3Specified() {
        return this.myLevels.length > 3;
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder("HW=");
        retVal.append(this.myLevels[0].toString());
        if (this.isL3Specified()) {
            retVal.append(',').append(this.units).append("xL3:").append(this.myLevels[this.myLevels.length - 3]);
        } else if (this.isL2Specified()) {
            retVal.append(',').append(this.units).append("xL2:").append(this.myLevels[this.myLevels.length - 2]);
        }
        retVal.append(',').append(this.cores).append("cores:").append(this.myLevels[this.myLevels.length - 1]);
        return retVal.toString();
    }

    public final VirtualMachine virtualise() {
        return new VirtualMachine(this, Runtime.getRuntime());
    }

    static {
        PREDEFINED.add(PPC__01);
        PREDEFINED.add(X86__01);
        PREDEFINED.add(X86__02);
        PREDEFINED.add(X86_64__02);
        PREDEFINED.add(X86_64__04);
        PREDEFINED.add(X86_64__08);
        PREDEFINED.add(X86_64__12);
        PREDEFINED.add(X86_64__16);
        PREDEFINED.add(X86_64__64);
        PREDEFINED.add(X86_64__96);
    }
}

