/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Iterator1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseStrategy;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.array.StrategyBuilder;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class NumberList<N extends Number>
implements List<N>,
RandomAccess,
Access1D<N>,
Access1D.Visitable<N>,
Mutate1D,
Mutate1D.Mixable<N> {
    private long myActualCount;
    private BasicArray<N> myStorage;
    private final DenseStrategy<N> myStrategy;

    public static <N extends Number> Collector<N, NumberList<N>, NumberList<N>> collector(DenseArray.Factory<N> arrayFactory) {
        Supplier<NumberList> tmpSupplier = () -> NumberList.factory(arrayFactory).make();
        BiConsumer<NumberList, Number> tmpAccumulator = (list, element) -> list.add((N)element);
        BinaryOperator tmpCombiner = (part1, part2) -> {
            part1.addAll((Collection)part2);
            return part1;
        };
        Function tmpIdentity = Function.identity();
        return Collector.of(tmpSupplier, tmpAccumulator, tmpCombiner, tmpIdentity, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <N extends Number> ListFactory<N> factory(DenseArray.Factory<N> arrayFactory) {
        return new ListFactory<N>(arrayFactory);
    }

    @Deprecated
    public static <N extends Number> NumberList<N> make(DenseArray.Factory<N> arrayFactory) {
        return NumberList.factory(arrayFactory).make();
    }

    @Deprecated
    public static NumberList<BigDecimal> makeBig() {
        return NumberList.factory(BigArray.FACTORY).make();
    }

    @Deprecated
    public static NumberList<ComplexNumber> makeComplex() {
        return NumberList.factory(ComplexArray.FACTORY).make();
    }

    @Deprecated
    public static NumberList<Double> makePrimitive() {
        return NumberList.factory(Primitive64Array.FACTORY).make();
    }

    @Deprecated
    public static NumberList<Quaternion> makeQuaternion() {
        return NumberList.factory(QuaternionArray.FACTORY).make();
    }

    @Deprecated
    public static NumberList<RationalNumber> makeRational() {
        return NumberList.factory(RationalArray.FACTORY).make();
    }

    NumberList(BasicArray<N> storage, DenseStrategy<N> strategy, long actualCount) {
        this.myStrategy = strategy;
        this.myStorage = storage;
        this.myActualCount = actualCount;
    }

    NumberList(DenseStrategy<N> strategy) {
        this.myStrategy = strategy;
        this.myStorage = strategy.makeInitial();
        this.myActualCount = 0L;
    }

    @Override
    public boolean add(double e) {
        this.ensureCapacity();
        this.myStorage.set(this.myActualCount++, e);
        return true;
    }

    @Override
    public void add(int index, N element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(long index, double addend) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.add(index, addend);
    }

    @Override
    public void add(long index, Number addend) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.add(index, addend);
    }

    @Override
    public boolean add(N e) {
        this.ensureCapacity();
        this.myStorage.set(this.myActualCount++, (Number)e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends N> elements) {
        for (Number tmpElement : elements) {
            this.add((N)tmpElement);
        }
        return true;
    }

    public boolean addAll(double[] elements) {
        for (double tmpElement : elements) {
            this.add(tmpElement);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends N> c) {
        throw new UnsupportedOperationException();
    }

    public long capacity() {
        return this.myStorage.count();
    }

    @Override
    public void clear() {
        this.myActualCount = 0L;
        this.myStorage.reset();
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Number) {
            return this.indexOf(object) >= 0;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object tmpObject : c) {
            if (this.contains(tmpObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long count() {
        return this.myActualCount;
    }

    @Override
    public double doubleValue(long index) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.doubleValue(index);
    }

    @Override
    public N get(int index) {
        if ((long)index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.get(index);
    }

    @Override
    public N get(long index) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.myStorage.get(index);
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<N> tmpIterator = this.listIterator();
        if (object == null) {
            while (tmpIterator.hasNext()) {
                if (tmpIterator.next() != null) continue;
                return tmpIterator.previousIndex();
            }
        } else {
            while (tmpIterator.hasNext()) {
                if (!object.equals(tmpIterator.next())) continue;
                return tmpIterator.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.myActualCount == 0L;
    }

    @Override
    public Iterator<N> iterator() {
        return Access1D.super.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<N> tmpIterator = this.listIterator(this.size());
        if (object == null) {
            while (tmpIterator.hasPrevious()) {
                if (tmpIterator.previous() != null) continue;
                return tmpIterator.nextIndex();
            }
        } else {
            while (tmpIterator.hasPrevious()) {
                if (!object.equals(tmpIterator.previous())) continue;
                return tmpIterator.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public ListIterator<N> listIterator() {
        return new Iterator1D(this);
    }

    @Override
    public ListIterator<N> listIterator(int index) {
        return new Iterator1D(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long index, BinaryFunction<N> mixer, double addend) {
        Objects.requireNonNull(mixer);
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BasicArray<N> basicArray = this.myStorage;
        synchronized (basicArray) {
            double oldValue = this.myStorage.doubleValue(index);
            double newValue = mixer.invoke(oldValue, addend);
            this.myStorage.set(index, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long index, BinaryFunction<N> mixer, N addend) {
        Objects.requireNonNull(mixer);
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BasicArray<N> basicArray = this.myStorage;
        synchronized (basicArray) {
            Object oldValue = this.myStorage.get(index);
            N newValue = mixer.invoke(oldValue, addend);
            this.myStorage.set(index, (Number)newValue);
            return newValue;
        }
    }

    @Override
    public N remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public N set(int index, N element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, double value) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.set(index, value);
    }

    @Override
    public void set(long index, Number value) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.set(index, value);
    }

    @Override
    public int size() {
        return (int)this.myActualCount;
    }

    @Override
    public NumberList<N> subList(int fromIndex, int toIndex) {
        NumberList<Object> retVal = new NumberList<Object>(this.myStrategy);
        if (this.myStorage instanceof Primitive64Array) {
            for (int i = 0; i < toIndex; ++i) {
                retVal.add(this.doubleValue(i));
            }
        } else {
            for (int i = 0; i < toIndex; ++i) {
                retVal.add(this.get(i));
            }
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.myStorage.get(i);
        }
        return array;
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (index >= this.myActualCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.myStorage.visitOne(index, visitor);
    }

    private void ensureCapacity() {
        if (this.myStorage.count() <= this.myActualCount) {
            if (this.myStrategy.isSegmented(this.myActualCount + 1L)) {
                this.myStorage = this.myStorage instanceof SegmentedArray ? ((SegmentedArray)this.myStorage).grow() : this.myStrategy.makeSegmented(this.myStorage);
            } else {
                long tmoNewTotalCount = this.myStrategy.grow(this.myActualCount);
                DenseArray<N> tmpStorage = this.myStrategy.make(tmoNewTotalCount);
                tmpStorage.fillMatching(this.myStorage);
                this.myStorage = tmpStorage;
            }
        }
    }

    public static final class ListFactory<N extends Number>
    extends StrategyBuilder<N, NumberList<N>, ListFactory<N>> {
        ListFactory(DenseArray.Factory<N> denseFactory) {
            super(denseFactory);
        }

        @Override
        public NumberList<N> make() {
            return new NumberList(this.getStrategy());
        }
    }
}

