/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.function.Consumer;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.AccessAnyD;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;

public interface MutateAnyD
extends StructureAnyD,
Mutate1D {
    @Override
    default public void add(long index, double addend) {
        this.add(StructureAnyD.reference(index, this.shape()), addend);
    }

    @Override
    default public void add(long index, Number addend) {
        this.add(StructureAnyD.reference(index, this.shape()), addend);
    }

    public void add(long[] var1, double var2);

    public void add(long[] var1, Number var2);

    @Override
    default public void set(long index, double value) {
        this.set(StructureAnyD.reference(index, this.shape()), value);
    }

    @Override
    default public void set(long index, Number value) {
        this.set(StructureAnyD.reference(index, this.shape()), value);
    }

    public void set(long[] var1, double var2);

    public void set(long[] var1, Number var2);

    public static interface Receiver<N extends Number>
    extends MutateAnyD,
    Fillable<N>,
    Consumer<AccessAnyD<?>> {
        @Override
        default public void accept(AccessAnyD<?> supplied) {
            if (!this.isAcceptable(supplied)) {
                throw new ProgrammingError("Not acceptable!");
            }
            supplied.loopAll((long[] ref) -> this.set(ref, (Number)supplied.get(ref)));
        }

        default public boolean isAcceptable(StructureAnyD supplier) {
            boolean retVal = true;
            int tmpRank = FunctionUtils.max(this.shape().length, this.shape().length);
            for (int i = 0; i < tmpRank; ++i) {
                retVal &= this.count(i) >= supplier.count(i);
            }
            return retVal;
        }
    }

    public static interface Modifiable<N extends Number>
    extends StructureAnyD,
    Mutate1D.Modifiable<N> {
        public void modifyOne(long[] var1, UnaryFunction<N> var2);
    }

    public static interface Mixable<N extends Number>
    extends StructureAnyD,
    Mutate1D.Mixable<N> {
        @Override
        default public double mix(long index, BinaryFunction<N> mixer, double addend) {
            return this.mix(StructureAnyD.reference(index, this.shape()), mixer, (N)addend);
        }

        @Override
        default public N mix(long index, BinaryFunction<N> mixer, N addend) {
            return this.mix(StructureAnyD.reference(index, this.shape()), mixer, addend);
        }

        public double mix(long[] var1, BinaryFunction<N> var2, double var3);

        public N mix(long[] var1, BinaryFunction<N> var2, N var3);
    }

    public static interface Fillable<N extends Number>
    extends StructureAnyD,
    Mutate1D.Fillable<N> {
        public void fillOne(long[] var1, N var2);

        public void fillOne(long[] var1, NullaryFunction<N> var2);
    }

    public static interface BiModifiable<N extends Number>
    extends StructureAnyD,
    Mutate1D.BiModifiable<N> {
    }
}

