/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMAppLogAggregationStatusBlock
extends HtmlBlock {
    private static final Logger LOG = LoggerFactory.getLogger(RMAppLogAggregationStatusBlock.class);
    private final ResourceManager rm;
    private final Configuration conf;

    @Inject
    RMAppLogAggregationStatusBlock(View.ViewContext ctx, ResourceManager rm, Configuration conf) {
        super(ctx);
        this.rm = rm;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        Map<NodeId, LogAggregationReport> logAggregationReports;
        ApplicationId appId;
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires Application ID"});
            return;
        }
        try {
            appId = Apps.toAppID((String)aid);
        }
        catch (Exception e) {
            this.puts(new Object[]{"Invalid Application ID: " + aid});
            return;
        }
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        Hamlet.DIV div_description = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table_description = div_description.table("#LogAggregationStatusDecription");
        table_description.tr().th(".ui-state-default", "Log Aggregation Status").th(".ui-state-default", "Description").__();
        table_description.tr().td(LogAggregationStatus.DISABLED.name()).td("Log Aggregation is Disabled.").__();
        table_description.tr().td(LogAggregationStatus.NOT_START.name()).td("Log Aggregation does not Start.").__();
        table_description.tr().td(LogAggregationStatus.RUNNING.name()).td("Log Aggregation is Running.").__();
        table_description.tr().td(LogAggregationStatus.RUNNING_WITH_FAILURE.name()).td("Log Aggregation is Running, but has failures in previous cycles").__();
        table_description.tr().td(LogAggregationStatus.SUCCEEDED.name()).td("Log Aggregation is Succeeded. All of the logs have been aggregated successfully.").__();
        table_description.tr().td(LogAggregationStatus.FAILED.name()).td("Log Aggregation is Failed. At least one of the logs have not been aggregated.").__();
        table_description.tr().td(LogAggregationStatus.TIME_OUT.name()).td("The application is finished, but the log aggregation status is not updated for a long time. Not sure whether the log aggregation is finished or not.").__();
        table_description.__();
        div_description.__();
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.h3("Log Aggregation: " + (rmApp == null ? "N/A" : (rmApp.getLogAggregationStatusForAppReport() == null ? "N/A" : rmApp.getLogAggregationStatusForAppReport().name()))).table("#LogAggregationStatus");
        int maxLogAggregationDiagnosticsInMemory = this.conf.getInt("yarn.resourcemanager.max-log-aggregation-diagnostics-in-memory", 10);
        table.tr().th(".ui-state-default", "NodeId").th(".ui-state-default", "Log Aggregation Status").th(".ui-state-default", "Last " + maxLogAggregationDiagnosticsInMemory + " Diagnostic Messages").th(".ui-state-default", "Last " + maxLogAggregationDiagnosticsInMemory + " Failure Messages").__();
        if (rmApp != null && (logAggregationReports = rmApp.getLogAggregationReportsForApp()) != null && !logAggregationReports.isEmpty()) {
            for (Map.Entry<NodeId, LogAggregationReport> report : logAggregationReports.entrySet()) {
                LogAggregationStatus status = report.getValue() == null ? null : report.getValue().getLogAggregationStatus();
                String message = report.getValue() == null ? null : report.getValue().getDiagnosticMessage();
                String failureMessage = report.getValue() == null ? null : ((RMAppImpl)rmApp).getLogAggregationFailureMessagesForNM(report.getKey());
                table.tr().td(report.getKey().toString()).td(status == null ? "N/A" : status.toString()).td(message == null ? "N/A" : message).td(failureMessage == null ? "N/A" : failureMessage).__();
            }
        }
        table.__();
        div.__();
    }
}

