/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementManager {
    private static final Logger LOG = LoggerFactory.getLogger(PlacementManager.class);
    List<PlacementRule> rules;
    ReentrantReadWriteLock.ReadLock readLock;
    ReentrantReadWriteLock.WriteLock writeLock;

    public PlacementManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void updateRules(List<PlacementRule> rules) {
        this.writeLock.lock();
        try {
            this.rules = rules;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPlacementContext placeApplication(ApplicationSubmissionContext asc, String user, boolean recovery) throws YarnException {
        this.readLock.lock();
        try {
            PlacementRule rule;
            if (null == this.rules || this.rules.isEmpty()) {
                ApplicationPlacementContext applicationPlacementContext = null;
                return applicationPlacementContext;
            }
            ApplicationPlacementContext placement = null;
            Iterator<PlacementRule> iterator = this.rules.iterator();
            while (iterator.hasNext() && (placement = (rule = iterator.next()).getPlacementForApp(asc, user, recovery)) == null) {
            }
            iterator = placement;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ApplicationPlacementContext placeApplication(ApplicationSubmissionContext asc, String user) throws YarnException {
        return this.placeApplication(asc, user, false);
    }

    @VisibleForTesting
    public List<PlacementRule> getPlacementRules() {
        return this.rules;
    }
}

