/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

public class NumaResourceAllocation
implements Serializable {
    private static final long serialVersionUID = 6339719798446595123L;
    private final ImmutableMap<String, Long> nodeVsMemory;
    private final ImmutableMap<String, Integer> nodeVsCpus;

    public NumaResourceAllocation(Map<String, Long> memoryAllocations, Map<String, Integer> cpuAllocations) {
        this.nodeVsMemory = ImmutableMap.copyOf(memoryAllocations);
        this.nodeVsCpus = ImmutableMap.copyOf(cpuAllocations);
    }

    public NumaResourceAllocation(String memNodeId, long memory, String cpuNodeId, int cpus) {
        this((Map<String, Long>)ImmutableMap.of((Object)memNodeId, (Object)memory), (Map<String, Integer>)ImmutableMap.of((Object)cpuNodeId, (Object)cpus));
    }

    public Set<String> getMemNodes() {
        return this.nodeVsMemory.keySet();
    }

    public Set<String> getCpuNodes() {
        return this.nodeVsCpus.keySet();
    }

    public ImmutableMap<String, Long> getNodeVsMemory() {
        return this.nodeVsMemory;
    }

    public ImmutableMap<String, Integer> getNodeVsCpus() {
        return this.nodeVsCpus;
    }

    public String toString() {
        return "NumaResourceAllocation{nodeVsMemory=" + this.nodeVsMemory + ", nodeVsCpus=" + this.nodeVsCpus + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumaResourceAllocation that = (NumaResourceAllocation)o;
        return Objects.equals(this.nodeVsMemory, that.nodeVsMemory) && Objects.equals(this.nodeVsCpus, that.nodeVsCpus);
    }

    public int hashCode() {
        return Objects.hash(this.nodeVsMemory, this.nodeVsCpus);
    }
}

