/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.NameserviceRPCMBean;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(name="NameserviceRPCActivity", about="Nameservice RPC Activity", context="dfs")
public class NameserviceRPCMetrics
implements NameserviceRPCMBean {
    public static final String NAMESERVICE_RPC_METRICS_PREFIX = "NameserviceActivity-";
    private final String nsId;
    private final MetricsRegistry registry = new MetricsRegistry("NameserviceRPCActivity");
    @Metric(value={"Time for the Router to proxy an operation to the Nameservice"})
    private MutableRate proxy;
    @Metric(value={"Number of operations the Router proxied to a NameService"})
    private MutableCounterLong proxyOp;
    @Metric(value={"Number of operations to hit a standby NN"})
    private MutableCounterLong proxyOpFailureStandby;
    @Metric(value={"Number of operations to fail to reach NN"})
    private MutableCounterLong proxyOpFailureCommunicate;
    @Metric(value={"Number of operations to hit no namenodes available"})
    private MutableCounterLong proxyOpNoNamenodes;
    @Metric(value={"Number of operations to hit permit limits"})
    private MutableCounterLong proxyOpPermitRejected;
    @Metric(value={"Number of operations accepted to hit a namenode"})
    private MutableCounterLong proxyOpPermitAccepted;

    public NameserviceRPCMetrics(Configuration conf, String nsId) {
        this.nsId = NAMESERVICE_RPC_METRICS_PREFIX + nsId;
        this.registry.tag("ns", "Nameservice", nsId);
    }

    public static NameserviceRPCMetrics create(Configuration conf, String nameService) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String nsId = nameService.isEmpty() ? "UndefinedNameService" + ThreadLocalRandom.current().nextInt() : nameService;
        return (NameserviceRPCMetrics)ms.register(NAMESERVICE_RPC_METRICS_PREFIX + nsId, "HDFS Federation NameService RPC Metrics", (Object)new NameserviceRPCMetrics(conf, nsId));
    }

    public void incrProxyOpFailureStandby() {
        this.proxyOpFailureStandby.incr();
    }

    @Override
    public long getProxyOpFailureStandby() {
        return this.proxyOpFailureStandby.value();
    }

    public void incrProxyOpFailureCommunicate() {
        this.proxyOpFailureCommunicate.incr();
    }

    @Override
    public long getProxyOpFailureCommunicate() {
        return this.proxyOpFailureCommunicate.value();
    }

    public void incrProxyOpNoNamenodes() {
        this.proxyOpNoNamenodes.incr();
    }

    @Override
    public long getProxyOpNoNamenodes() {
        return this.proxyOpNoNamenodes.value();
    }

    public void incrProxyOpPermitRejected() {
        this.proxyOpPermitRejected.incr();
    }

    @Override
    public long getProxyOpPermitRejected() {
        return this.proxyOpPermitRejected.value();
    }

    public void incrProxyOpPermitAccepted() {
        this.proxyOpPermitAccepted.incr();
    }

    @Override
    public long getProxyOpPermitAccepted() {
        return this.proxyOpPermitAccepted.value();
    }

    public void addProxyTime(long time) {
        this.proxy.add(time);
        this.proxyOp.incr();
    }

    @Override
    public double getProxyAvg() {
        return this.proxy.lastStat().mean();
    }

    @Override
    public long getProxyOps() {
        return this.proxyOp.value();
    }

    public String getNsId() {
        return this.nsId;
    }
}

