/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.CompositeContinuationToken;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContextBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

public class ParallelDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private ParallelDocumentQueryExecutionContext(IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, String collectionRid, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(client, partitionKeyRanges, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(client, targetRanges, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, partitionedQueryExecutionInfo.getQueryInfo().getRewrittenQuery(), collectionRid, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        try {
            super.initialize(collectionRid, targetRanges, initialPageSize, feedOptions.getRequestContinuation());
            return Observable.just(context);
        }
        catch (DocumentClientException dce) {
            return Observable.error((Throwable)dce);
        }
    }

    private void initialize(String collectionRid, List<PartitionKeyRange> targetRanges, int initialPageSize, String continuationToken) throws DocumentClientException {
        HashMap<PartitionKeyRange, String> partitionKeyRangeToContinuationTokenMap = new HashMap<PartitionKeyRange, String>();
        if (continuationToken == null) {
            for (PartitionKeyRange targetRange : targetRanges) {
                partitionKeyRangeToContinuationTokenMap.put(targetRange, null);
            }
        } else {
            Utils.ValueHolder outCompositeContinuationToken = new Utils.ValueHolder();
            if (!CompositeContinuationToken.tryParse(continuationToken, (Utils.ValueHolder<CompositeContinuationToken>)outCompositeContinuationToken)) {
                String message = String.format("Invalid JSON in continuation token %s for Parallel~Context", continuationToken);
                throw new DocumentClientException(400, message);
            }
            CompositeContinuationToken compositeContinuationToken = (CompositeContinuationToken)((Object)outCompositeContinuationToken.v);
            List<PartitionKeyRange> filteredPartitionKeyRanges = this.getPartitionKeyRangesForContinuation(compositeContinuationToken, targetRanges);
            partitionKeyRangeToContinuationTokenMap.put(filteredPartitionKeyRanges.get(0), compositeContinuationToken.getToken());
            for (int i = 1; i < filteredPartitionKeyRanges.size(); ++i) {
                partitionKeyRangeToContinuationTokenMap.put(filteredPartitionKeyRanges.get(i), null);
            }
        }
        super.initialize(collectionRid, partitionKeyRangeToContinuationTokenMap, initialPageSize, this.querySpec);
    }

    private List<PartitionKeyRange> getPartitionKeyRangesForContinuation(CompositeContinuationToken compositeContinuationToken, List<PartitionKeyRange> partitionKeyRanges) throws DocumentClientException {
        int startIndex = this.FindTargetRangeAndExtractContinuationTokens(partitionKeyRanges, compositeContinuationToken.getRange());
        ArrayList<PartitionKeyRange> rightHandSideRanges = new ArrayList<PartitionKeyRange>();
        for (int i = startIndex; i < partitionKeyRanges.size(); ++i) {
            rightHandSideRanges.add(partitionKeyRanges.get(i));
        }
        return rightHandSideRanges;
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        List obs = this.documentProducers.stream().sorted((dp1, dp2) -> dp1.targetRange.getMinInclusive().compareTo(dp2.targetRange.getMinInclusive())).map(dp -> dp.produceAsync()).collect(Collectors.toList());
        return Observable.concat(obs).compose(new EmptyPagesFilterTransformer(new RequestChargeTracker()));
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        return this.drainAsync(this.feedOptions.getMaxItemCount());
    }

    @Override
    protected DocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, String initialContinuationToken, int initialPageSize, FeedOptions feedOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc) {
        return new DocumentProducer<T>(this.client, collectionRid, feedOptions, createRequestFunc, executeFunc, targetRange, collectionRid, (Func0<IDocumentClientRetryPolicy>)((Func0)() -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy()), this.resourceType, this.correlatedActivityId, initialPageSize, initialContinuationToken, this.top);
    }

    private static class EmptyPagesFilterTransformer<T extends Resource>
    implements Observable.Transformer<DocumentProducer.DocumentProducerFeedResponse, FeedResponse<T>> {
        private final RequestChargeTracker tracker;
        private DocumentProducer.DocumentProducerFeedResponse previousPage;

        public EmptyPagesFilterTransformer(RequestChargeTracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException("Request Charge Tracker must not be null.");
            }
            this.tracker = tracker;
            this.previousPage = null;
        }

        private DocumentProducer.DocumentProducerFeedResponse plusCharge(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, double charge) {
            FeedResponse newPage;
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            double pageCharge = page.getRequestCharge();
            headers.put("x-ms-request-charge", String.valueOf(pageCharge += charge));
            documentProducerFeedResponse.pageResult = newPage = BridgeInternal.createFeedResponseWithQueryMetrics((List)page.getResults(), headers, (ConcurrentMap)page.getQueryMetrics());
            return documentProducerFeedResponse;
        }

        private DocumentProducer.DocumentProducerFeedResponse addCompositeContinuationToken(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, String compositeContinuationToken) {
            FeedResponse newPage;
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            headers.put("x-ms-continuation", compositeContinuationToken);
            documentProducerFeedResponse.pageResult = newPage = BridgeInternal.createFeedResponseWithQueryMetrics((List)page.getResults(), headers, (ConcurrentMap)page.getQueryMetrics());
            return documentProducerFeedResponse;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf((Object)"x-ms-request-charge", (Object)String.valueOf(requestCharge));
        }

        public Observable<FeedResponse<T>> call(Observable<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.filter(documentProducerFeedResponse -> {
                if (documentProducerFeedResponse.pageResult.getResults().isEmpty()) {
                    this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                    return false;
                }
                return true;
            }).map(documentProducerFeedResponse -> {
                double charge = this.tracker.getAndResetCharge();
                if (charge > 0.0) {
                    return this.plusCharge((DocumentProducer.DocumentProducerFeedResponse)documentProducerFeedResponse, charge);
                }
                return documentProducerFeedResponse;
            }).concatWith(Observable.defer(() -> Observable.just(null))).map(documentProducerFeedResponse -> {
                ImmutablePair previousCurrent = new ImmutablePair((Object)this.previousPage, documentProducerFeedResponse);
                this.previousPage = documentProducerFeedResponse;
                return previousCurrent;
            }).skip(1).map(currentNext -> {
                CompositeContinuationToken compositeContinuationTokenDom;
                String compositeContinuationToken;
                DocumentProducer.DocumentProducerFeedResponse current = (DocumentProducer.DocumentProducerFeedResponse)currentNext.left;
                DocumentProducer.DocumentProducerFeedResponse next = (DocumentProducer.DocumentProducerFeedResponse)currentNext.right;
                String backendContinuationToken = current.pageResult.getResponseContinuation();
                if (backendContinuationToken == null) {
                    if (next == null) {
                        compositeContinuationToken = null;
                    } else {
                        compositeContinuationTokenDom = new CompositeContinuationToken(null, (Range<String>)next.sourcePartitionKeyRange.toRange());
                        compositeContinuationToken = compositeContinuationTokenDom.toJson();
                    }
                } else {
                    compositeContinuationTokenDom = new CompositeContinuationToken(backendContinuationToken, (Range<String>)current.sourcePartitionKeyRange.toRange());
                    compositeContinuationToken = compositeContinuationTokenDom.toJson();
                }
                DocumentProducer.DocumentProducerFeedResponse page = current;
                page = this.addCompositeContinuationToken(page, compositeContinuationToken);
                return page;
            }).map(documentProducerFeedResponse -> documentProducerFeedResponse.pageResult).switchIfEmpty(Observable.defer(() -> Observable.just((Object)BridgeInternal.createFeedResponse((List)Utils.immutableListOf(), EmptyPagesFilterTransformer.headerResponse(this.tracker.getAndResetCharge())))));
        }
    }
}

