/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.AbstractContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerCleanup;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerRelaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.RecoverPausedContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.RecoveredContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.SignalContainersLauncherEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainersLauncher
extends AbstractService
implements AbstractContainersLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ContainersLauncher.class);
    private Context context;
    private ContainerExecutor exec;
    private Dispatcher dispatcher;
    private ContainerManagerImpl containerManager;
    private LocalDirsHandlerService dirsHandler;
    @VisibleForTesting
    public ExecutorService containerLauncher = HadoopExecutors.newCachedThreadPool((ThreadFactory)new ThreadFactoryBuilder().setNameFormat("ContainersLauncher #%d").build());
    @VisibleForTesting
    public final Map<ContainerId, ContainerLaunch> running = Collections.synchronizedMap(new HashMap());

    public ContainersLauncher() {
        super("containers-launcher");
    }

    @VisibleForTesting
    public ContainersLauncher(Context context, Dispatcher dispatcher, ContainerExecutor exec, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        this();
        this.init(context, dispatcher, exec, dirsHandler, containerManager);
    }

    @Override
    public void init(Context nmContext, Dispatcher nmDispatcher, ContainerExecutor containerExec, LocalDirsHandlerService nmDirsHandler, ContainerManagerImpl nmContainerManager) {
        this.exec = containerExec;
        this.context = nmContext;
        this.dispatcher = nmDispatcher;
        this.dirsHandler = nmDirsHandler;
        this.containerManager = nmContainerManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        try {
            FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (UnsupportedFileSystemException e) {
            throw new YarnRuntimeException("Failed to start ContainersLauncher", (Throwable)e);
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        this.containerLauncher.shutdownNow();
        super.serviceStop();
    }

    public void handle(ContainersLauncherEvent event) {
        Container container = event.getContainer();
        ContainerId containerId = container.getContainerId();
        switch ((ContainersLauncherEventType)event.getType()) {
            case LAUNCH_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                ContainerLaunch launch = new ContainerLaunch(this.context, this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler, this.containerManager);
                this.containerLauncher.submit(launch);
                this.running.put(containerId, launch);
                break;
            }
            case RELAUNCH_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                ContainerRelaunch relaunch = new ContainerRelaunch(this.context, this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler, this.containerManager);
                this.containerLauncher.submit(relaunch);
                this.running.put(containerId, relaunch);
                break;
            }
            case RECOVER_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                RecoveredContainerLaunch launch = new RecoveredContainerLaunch(this.context, this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler, this.containerManager);
                this.containerLauncher.submit(launch);
                this.running.put(containerId, launch);
                break;
            }
            case RECOVER_PAUSED_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                RecoverPausedContainerLaunch launch = new RecoverPausedContainerLaunch(this.context, this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler, this.containerManager);
                this.containerLauncher.submit(launch);
                break;
            }
            case CLEANUP_CONTAINER: {
                this.cleanup(event, containerId, true);
                break;
            }
            case CLEANUP_CONTAINER_FOR_REINIT: {
                this.cleanup(event, containerId, false);
                break;
            }
            case SIGNAL_CONTAINER: {
                SignalContainersLauncherEvent signalEvent = (SignalContainersLauncherEvent)event;
                ContainerLaunch runningContainer = this.running.get(containerId);
                if (runningContainer == null) {
                    LOG.info("Container " + containerId + " not running, nothing to signal.");
                    return;
                }
                try {
                    runningContainer.signalContainer(signalEvent.getCommand());
                }
                catch (IOException e) {
                    LOG.warn("Got exception while signaling container " + containerId + " with command " + signalEvent.getCommand());
                }
                break;
            }
            case PAUSE_CONTAINER: {
                ContainerLaunch launchedContainer = this.running.get(containerId);
                if (launchedContainer == null) {
                    return;
                }
                try {
                    launchedContainer.pauseContainer();
                }
                catch (Exception e) {
                    LOG.info("Got exception while pausing container: " + StringUtils.stringifyException((Throwable)e));
                }
                break;
            }
            case RESUME_CONTAINER: {
                ContainerLaunch launchCont = this.running.get(containerId);
                if (launchCont == null) {
                    return;
                }
                try {
                    launchCont.resumeContainer();
                    break;
                }
                catch (Exception e) {
                    LOG.info("Got exception while resuming container: " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    @VisibleForTesting
    void cleanup(ContainersLauncherEvent event, ContainerId containerId, boolean async) {
        ContainerLaunch existingLaunch = this.running.remove(containerId);
        if (existingLaunch == null) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
            return;
        }
        ContainerCleanup cleanup = new ContainerCleanup(this.context, this.getConfig(), this.dispatcher, this.exec, event.getContainer(), existingLaunch);
        if (async) {
            this.containerLauncher.submit(cleanup);
        } else {
            cleanup.run();
        }
    }
}

