/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineMetricSubDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRunDocument
implements TimelineDocument<FlowRunDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowRunDocument.class);
    private String id;
    private final String type = TimelineEntityType.YARN_FLOW_RUN.toString();
    private String clusterId;
    private String username;
    private String flowName;
    private Long flowRunId;
    private String flowVersion;
    private long minStartTime;
    private long maxEndTime;
    private final Map<String, TimelineMetricSubDoc> metrics = new HashMap<String, TimelineMetricSubDoc>();

    public FlowRunDocument() {
    }

    public FlowRunDocument(TimelineCollectorContext collectorContext, Set<TimelineMetric> metrics) {
        this.clusterId = collectorContext.getClusterId();
        this.username = collectorContext.getUserId();
        this.flowName = collectorContext.getFlowName();
        this.flowRunId = collectorContext.getFlowRunId();
        this.transformMetrics(metrics);
    }

    private void transformMetrics(Set<TimelineMetric> timelineMetrics) {
        for (TimelineMetric metric : timelineMetrics) {
            TimelineMetricSubDoc metricSubDoc = new TimelineMetricSubDoc(metric);
            this.metrics.put(metric.getId(), metricSubDoc);
        }
    }

    @Override
    public void merge(FlowRunDocument flowRunDoc) {
        if (flowRunDoc.getMinStartTime() > 0L) {
            this.minStartTime = flowRunDoc.getMinStartTime();
        }
        if (flowRunDoc.getMaxEndTime() > 0L) {
            this.maxEndTime = flowRunDoc.getMaxEndTime();
        }
        this.clusterId = flowRunDoc.getClusterId();
        this.flowName = flowRunDoc.getFlowName();
        this.id = flowRunDoc.getId();
        this.username = flowRunDoc.getUsername();
        this.flowVersion = flowRunDoc.getFlowVersion();
        this.flowRunId = flowRunDoc.getFlowRunId();
        this.aggregateMetrics(flowRunDoc.getMetrics());
    }

    private void aggregateMetrics(Map<String, TimelineMetricSubDoc> metricSubDocMap) {
        for (Map.Entry<String, TimelineMetricSubDoc> metricEntry : metricSubDocMap.entrySet()) {
            String metricId = metricEntry.getKey();
            TimelineMetricSubDoc metricValue = metricEntry.getValue();
            if (this.metrics.containsKey(metricId)) {
                TimelineMetric incomingMetric = metricValue.fetchTimelineMetric();
                TimelineMetric baseMetric = this.metrics.get(metricId).fetchTimelineMetric();
                if (incomingMetric.getValues().size() > 0) {
                    baseMetric = this.aggregate(incomingMetric, baseMetric);
                    this.metrics.put(metricId, new TimelineMetricSubDoc(baseMetric));
                    continue;
                }
                LOG.debug("No incoming metric to aggregate for : {}", (Object)baseMetric.getId());
                continue;
            }
            this.metrics.put(metricId, metricValue);
        }
    }

    private TimelineMetric aggregate(TimelineMetric incomingMetric, TimelineMetric baseMetric) {
        switch (baseMetric.getRealtimeAggregationOp()) {
            case SUM: {
                baseMetric = TimelineMetricOperation.SUM.aggregate(incomingMetric, baseMetric, null);
                break;
            }
            case AVG: {
                baseMetric = TimelineMetricOperation.AVG.aggregate(incomingMetric, baseMetric, null);
                break;
            }
            case MAX: {
                baseMetric = TimelineMetricOperation.MAX.aggregate(incomingMetric, baseMetric, null);
                break;
            }
            case REPLACE: {
                baseMetric = TimelineMetricOperation.REPLACE.aggregate(incomingMetric, baseMetric, null);
            }
            default: {
                LOG.warn("Unknown TimelineMetricOperation: {}", (Object)baseMetric.getRealtimeAggregationOp());
            }
        }
        return baseMetric;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public void setFlowRunId(Long flowRunId) {
        this.flowRunId = flowRunId;
    }

    public Map<String, TimelineMetricSubDoc> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, TimelineMetricSubDoc> metrics) {
        this.metrics.putAll(metrics);
    }

    public Set<TimelineMetric> fetchTimelineMetrics() {
        HashSet<TimelineMetric> metricSet = new HashSet<TimelineMetric>();
        for (TimelineMetricSubDoc metricSubDoc : this.metrics.values()) {
            metricSet.add(metricSubDoc.fetchTimelineMetric());
        }
        return metricSet;
    }

    public long getMinStartTime() {
        return this.minStartTime;
    }

    public void setMinStartTime(long minStartTime) {
        this.minStartTime = minStartTime;
    }

    public long getMaxEndTime() {
        return this.maxEndTime;
    }

    public void setMaxEndTime(long maxEndTime) {
        this.maxEndTime = maxEndTime;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getCreatedTime() {
        return this.minStartTime;
    }

    @Override
    public void setCreatedTime(long createdTime) {
        if (this.minStartTime == 0L) {
            this.minStartTime = createdTime;
        }
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }
}

