/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.RequestOptions;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.DocumentServiceRequestContext;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;
import rx.observables.StringObservable;

public class RxDocumentServiceRequest {
    private static final char PREFER_HEADER_SEPERATOR = ';';
    private static final String PREFER_HEADER_VALUE_FORMAT = "%s=%s";
    public volatile boolean forcePartitionKeyRangeRefresh;
    public volatile boolean forceCollectionRoutingMapRefresh;
    private String resourceId;
    private final ResourceType resourceType;
    private final Map<String, String> headers;
    private volatile String continuation;
    private boolean isMedia = false;
    private final boolean isNameBased;
    private final OperationType operationType;
    private final String resourceAddress;
    public volatile boolean forceNameCacheRefresh;
    private volatile URI endpointOverride = null;
    private final String activityId;
    private volatile String resourceFullName;
    private volatile String originalSessionToken;
    private volatile PartitionKeyRangeIdentity partitionKeyRangeIdentity;
    private volatile Integer defaultReplicaIndex;
    public DocumentServiceRequestContext requestContext;
    private Observable<byte[]> contentObservable;
    private byte[] byteContent;
    public boolean UseGatewayMode;
    private volatile boolean isDisposed = false;
    public volatile String entityId;
    public volatile String queryString;
    public volatile boolean isFeed;
    public volatile AuthorizationTokenType authorizationTokenType;
    public volatile Map<String, Object> properties;

    public boolean isReadOnlyRequest() {
        return this.operationType == OperationType.Read || this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Head || this.operationType == OperationType.HeadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery;
    }

    public boolean isReadOnlyScript() {
        String isReadOnlyScript = this.headers.get("x-ms-is-readonly-script");
        if (StringUtils.isEmpty((CharSequence)isReadOnlyScript)) {
            return false;
        }
        return this.operationType.equals((Object)OperationType.ExecuteJavaScript) && isReadOnlyScript.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    private RxDocumentServiceRequest(OperationType operationType, String resourceIdOrFullName, ResourceType resourceType, byte[] byteContent, Map<String, String> headers, boolean isNameBased, AuthorizationTokenType authorizationTokenType) {
        this.operationType = operationType;
        this.forceNameCacheRefresh = false;
        this.resourceType = resourceType;
        this.byteContent = byteContent;
        this.headers = headers != null ? headers : new HashMap();
        this.activityId = Utils.randomUUID().toString();
        this.isFeed = false;
        this.isNameBased = isNameBased;
        if (!isNameBased) {
            this.resourceId = resourceIdOrFullName;
        }
        this.resourceAddress = resourceIdOrFullName;
        this.authorizationTokenType = authorizationTokenType;
        this.requestContext = new DocumentServiceRequestContext();
        if (StringUtils.isNotEmpty((CharSequence)this.headers.get("x-ms-documentdb-partitionkeyrangeid"))) {
            this.partitionKeyRangeIdentity = PartitionKeyRangeIdentity.fromHeader(this.headers.get("x-ms-documentdb-partitionkeyrangeid"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RxDocumentServiceRequest(OperationType operationType, String resourceIdOrFullName, ResourceType resourceType, String path, Map<String, String> headers) {
        this.requestContext = new DocumentServiceRequestContext();
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.requestContext.sessionToken = null;
        this.headers = headers != null ? headers : new HashMap();
        this.activityId = Utils.randomUUID().toString();
        this.isFeed = false;
        PathInfo pathInfo = new PathInfo(false, null, null, false);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (!PathsHelper.tryParsePathSegments(path, pathInfo, null)) throw new IllegalArgumentException("Entity with the specified id does not exist in the system.");
            this.isNameBased = pathInfo.isNameBased;
            this.isFeed = pathInfo.isFeed;
            resourceIdOrFullName = pathInfo.resourceIdOrFullName;
            if (!this.isNameBased) {
                this.resourceId = resourceType == ResourceType.Media ? RxDocumentServiceRequest.getAttachmentIdFromMediaId(resourceIdOrFullName) : resourceIdOrFullName;
                this.resourceAddress = resourceIdOrFullName;
                if (!(!StringUtils.isNotEmpty((CharSequence)this.resourceId) || ((Boolean)ResourceId.tryParse(this.resourceId).getLeft()).booleanValue() || resourceType.equals((Object)ResourceType.Offer) || resourceType.equals((Object)ResourceType.Media) || resourceType.equals((Object)ResourceType.MasterPartition) || resourceType.equals((Object)ResourceType.ServerPartition) || resourceType.equals((Object)ResourceType.DatabaseAccount) || resourceType.equals((Object)ResourceType.RidRange))) {
                    throw new IllegalArgumentException(String.format("The value %s specified  for query %s is invalid.", path, "$resolveFor"));
                }
            } else {
                this.resourceAddress = resourceIdOrFullName;
                this.resourceId = null;
            }
        } else {
            this.isNameBased = false;
            this.resourceAddress = resourceIdOrFullName;
        }
        if (!StringUtils.isNotEmpty((CharSequence)this.headers.get("x-ms-documentdb-partitionkeyrangeid"))) return;
        this.partitionKeyRangeIdentity = PartitionKeyRangeIdentity.fromHeader(this.headers.get("x-ms-documentdb-partitionkeyrangeid"));
    }

    private RxDocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, Observable<byte[]> contentObservable, byte[] content, String path, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(operationType, resourceId, resourceType, path, headers);
        this.authorizationTokenType = authorizationTokenType;
        this.byteContent = content;
        this.contentObservable = contentObservable;
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, Observable<byte[]> contentObservable, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, contentObservable, null, path, headers, authorizationTokenType);
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, byte[] byteContent, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, null, byteContent, path, headers, authorizationTokenType);
    }

    private RxDocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        this(operationType, RxDocumentServiceRequest.extractIdFromUri(path), resourceType, null, null, path, headers, authorizationTokenType);
    }

    public void setContentBytes(byte[] bytes) {
        this.byteContent = bytes;
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Observable<byte[]> content, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, content, headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Observable<byte[]> content, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, content, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, InputStream inputStream, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, (Observable<byte[]>)StringObservable.from((InputStream)inputStream), headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, InputStream inputStream, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, (Observable<byte[]>)StringObservable.from((InputStream)inputStream), headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        return RxDocumentServiceRequest.create(operation, resourceType, relativePath, resource, headers, (Object)null);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(operation, resourceType, relativePath, resource.toJson().getBytes(StandardCharsets.UTF_8), headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        return request;
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, String query, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(operation, resourceType, relativePath, query.getBytes(StandardCharsets.UTF_8), headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        return request;
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, String query, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, query.getBytes(StandardCharsets.UTF_8), headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(ResourceType resourceType, String relativePath, SqlQuerySpec querySpec, QueryCompatibilityMode queryCompatibilityMode, Map<String, String> headers) {
        String queryText;
        OperationType operation;
        switch (queryCompatibilityMode) {
            case SqlQuery: {
                if (querySpec.getParameters() != null && querySpec.getParameters().size() > 0) {
                    throw new IllegalArgumentException(String.format("Unsupported argument in query compatibility mode '{%s}'", queryCompatibilityMode.name()));
                }
                operation = OperationType.SqlQuery;
                queryText = querySpec.getQueryText();
                break;
            }
            default: {
                operation = OperationType.Query;
                queryText = querySpec.toJson();
            }
        }
        Observable body = StringObservable.encode((Observable)Observable.just((Object)queryText), (Charset)StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, (Observable<byte[]>)body, headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return RxDocumentServiceRequest.create(operation, resourceType, relativePath, headers, (Object)null);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers, Object options) {
        RxDocumentServiceRequest request = new RxDocumentServiceRequest(operation, resourceType, relativePath, headers, AuthorizationTokenType.PrimaryMasterKey);
        request.properties = RxDocumentServiceRequest.getProperties(options);
        return request;
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, Resource resource, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, resourceContent, headers, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, Resource resource, ResourceType resourceType, String relativePath, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceType, relativePath, resourceContent, headers, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers) {
        return new RxDocumentServiceRequest(operation, resourceId, resourceType, null, headers, false, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operation, resourceId, resourceType, null, headers, false, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Resource resource, Map<String, String> headers) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceId, resourceType, resourceContent, headers, false, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Resource resource, Map<String, String> headers, AuthorizationTokenType authorizationTokenType) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operation, resourceId, resourceType, resourceContent, headers, false, authorizationTokenType);
    }

    public static RxDocumentServiceRequest create(OperationType operation, ResourceType resourceType) {
        return new RxDocumentServiceRequest(operation, null, resourceType, null, null);
    }

    public static RxDocumentServiceRequest createFromName(OperationType operationType, String resourceFullName, ResourceType resourceType) {
        return new RxDocumentServiceRequest(operationType, resourceFullName, resourceType, null, new HashMap<String, String>(), true, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest createFromName(OperationType operationType, String resourceFullName, ResourceType resourceType, AuthorizationTokenType authorizationTokenType) {
        return new RxDocumentServiceRequest(operationType, resourceFullName, resourceType, null, new HashMap<String, String>(), true, authorizationTokenType);
    }

    public static RxDocumentServiceRequest createFromName(OperationType operationType, Resource resource, String resourceFullName, ResourceType resourceType) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operationType, resourceFullName, resourceType, resourceContent, new HashMap<String, String>(), true, AuthorizationTokenType.PrimaryMasterKey);
    }

    public static RxDocumentServiceRequest createFromName(OperationType operationType, Resource resource, String resourceFullName, ResourceType resourceType, AuthorizationTokenType authorizationTokenType) {
        byte[] resourceContent = resource.toJson().getBytes(StandardCharsets.UTF_8);
        return new RxDocumentServiceRequest(operationType, resourceFullName, resourceType, resourceContent, new HashMap<String, String>(), true, authorizationTokenType);
    }

    private static String extractIdFromUri(String path) {
        String[] pathParts;
        if (path.length() == 0) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        if ((pathParts = StringUtils.split((String)(path = path + '='), (String)"/")).length % 2 == 0) {
            return pathParts[pathParts.length - 2];
        }
        return pathParts[pathParts.length - 3];
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Utils.Base64Decoder.decode(mediaId.replace('-', '/').getBytes());
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Utils.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsNameBased() {
        return this.isNameBased;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public boolean isForceNameCacheRefresh() {
        return this.forceNameCacheRefresh;
    }

    public void setForceNameCacheRefresh(boolean forceNameCacheRefresh) {
        this.forceNameCacheRefresh = forceNameCacheRefresh;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    public void routeTo(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.setPartitionKeyRangeIdentity(partitionKeyRangeIdentity);
    }

    public void setPartitionKeyRangeIdentity(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.partitionKeyRangeIdentity = partitionKeyRangeIdentity;
        if (partitionKeyRangeIdentity != null) {
            this.headers.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeIdentity.toHeader());
        } else {
            this.headers.remove("x-ms-documentdb-partitionkeyrangeid");
        }
    }

    public String getOriginalSessionToken() {
        return this.originalSessionToken;
    }

    public void setOriginalSessionToken(String originalSessionToken) {
        this.originalSessionToken = originalSessionToken;
    }

    public void setDefaultReplicaIndex(Integer defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }

    public boolean isChangeFeedRequest() {
        return this.headers.containsKey("A-IM");
    }

    public boolean isWritingToMaster() {
        return this.operationType.isWriteOperation() && this.resourceType.isMasterResource();
    }

    public boolean isReadingFromMaster() {
        return this.resourceType == ResourceType.Offer || this.resourceType == ResourceType.Database || this.resourceType == ResourceType.User || this.resourceType == ResourceType.Permission || this.resourceType == ResourceType.Topology || this.resourceType == ResourceType.DatabaseAccount || this.resourceType == ResourceType.PartitionKeyRange || this.resourceType == ResourceType.DocumentCollection && (this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery);
    }

    public boolean isValidAddress(ResourceType resourceType) {
        ResourceType resourceTypeToValidate = ResourceType.Unknown;
        if (resourceType != ResourceType.Unknown) {
            resourceTypeToValidate = resourceType;
        } else if (!this.isFeed) {
            resourceTypeToValidate = this.resourceType;
        } else {
            if (this.resourceType == ResourceType.Database) {
                return true;
            }
            if (this.resourceType == ResourceType.DocumentCollection || this.resourceType == ResourceType.User) {
                resourceTypeToValidate = ResourceType.Database;
            } else if (this.resourceType == ResourceType.Permission) {
                resourceTypeToValidate = ResourceType.User;
            } else if (this.resourceType == ResourceType.Document || this.resourceType == ResourceType.StoredProcedure || this.resourceType == ResourceType.UserDefinedFunction || this.resourceType == ResourceType.Trigger || this.resourceType == ResourceType.Conflict || this.resourceType == ResourceType.PartitionKeyRange) {
                resourceTypeToValidate = ResourceType.DocumentCollection;
            } else if (this.resourceType == ResourceType.Attachment) {
                resourceTypeToValidate = ResourceType.Document;
            } else {
                return false;
            }
        }
        if (this.isNameBased) {
            return PathsHelper.validateResourceFullName(resourceType != ResourceType.Unknown ? resourceType : resourceTypeToValidate, this.resourceAddress);
        }
        return PathsHelper.validateResourceId(resourceTypeToValidate, this.resourceId);
    }

    public void addPreferHeader(String preferHeaderName, String preferHeaderValue) {
        String headerToAdd = String.format(PREFER_HEADER_VALUE_FORMAT, preferHeaderName, preferHeaderValue);
        String preferHeader = this.headers.get("Prefer");
        preferHeader = StringUtils.isNotEmpty((CharSequence)preferHeader) ? preferHeader + ';' + headerToAdd : headerToAdd;
        this.headers.put("Prefer", preferHeader);
    }

    public static RxDocumentServiceRequest CreateFromResource(RxDocumentServiceRequest request, Resource modifiedResource) {
        RxDocumentServiceRequest modifiedRequest = !request.getIsNameBased() ? RxDocumentServiceRequest.create(request.getOperationType(), request.getResourceId(), request.getResourceType(), modifiedResource, request.headers) : RxDocumentServiceRequest.createFromName(request.getOperationType(), modifiedResource, request.getResourceAddress(), request.getResourceType());
        return modifiedRequest;
    }

    public void clearRoutingHints() {
        this.partitionKeyRangeIdentity = null;
        this.requestContext.resolvedPartitionKeyRange = null;
    }

    public Observable<byte[]> getContentObservable() {
        return this.contentObservable;
    }

    public byte[] getContent() {
        return this.byteContent;
    }

    public RxDocumentServiceRequest clone() {
        RxDocumentServiceRequest rxDocumentServiceRequest = RxDocumentServiceRequest.create(this.getOperationType(), this.resourceId, this.getResourceType(), this.getHeaders());
        rxDocumentServiceRequest.setContentBytes(this.getContent());
        rxDocumentServiceRequest.setContinuation(this.getContinuation());
        rxDocumentServiceRequest.setDefaultReplicaIndex(this.getDefaultReplicaIndex());
        rxDocumentServiceRequest.setEndpointOverride(this.getEndpointOverride());
        rxDocumentServiceRequest.setForceNameCacheRefresh(this.isForceNameCacheRefresh());
        rxDocumentServiceRequest.setIsMedia(this.getIsMedia());
        rxDocumentServiceRequest.setOriginalSessionToken(this.getOriginalSessionToken());
        rxDocumentServiceRequest.setPartitionKeyRangeIdentity(this.getPartitionKeyRangeIdentity());
        rxDocumentServiceRequest.contentObservable = this.getContentObservable();
        rxDocumentServiceRequest.forceCollectionRoutingMapRefresh = this.forceCollectionRoutingMapRefresh;
        rxDocumentServiceRequest.forcePartitionKeyRangeRefresh = this.forcePartitionKeyRangeRefresh;
        rxDocumentServiceRequest.UseGatewayMode = this.UseGatewayMode;
        rxDocumentServiceRequest.queryString = this.queryString;
        rxDocumentServiceRequest.requestContext = this.requestContext;
        return rxDocumentServiceRequest;
    }

    public void Dispose() {
        if (this.isDisposed) {
            return;
        }
        if (this.byteContent != null) {
            this.byteContent = null;
        }
        this.isDisposed = true;
    }

    private static Map<String, Object> getProperties(Object options) {
        if (options == null) {
            return null;
        }
        if (options instanceof RequestOptions) {
            return ((RequestOptions)options).getProperties();
        }
        if (options instanceof FeedOptionsBase) {
            return ((FeedOptionsBase)options).getProperties();
        }
        return null;
    }
}

