/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.routing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.microsoft.azure.cosmosdb.Undefined;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.routing.BoolPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.IPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.InfinityPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.MaxNumberPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.MaxStringPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.MinNumberPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.MinStringPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.NullPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.NumberPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.StringPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.internal.routing.UndefinedPartitionKeyComponent;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=PartitionKeyInternalJsonSerializer.class)
@JsonDeserialize(using=PartitionKeyInternalJsonDeserializer.class)
public class PartitionKeyInternal
implements Comparable<PartitionKeyInternal> {
    private static final String TYPE = "type";
    private static final String MIN_NUMBER = "MinNumber";
    private static final String MAX_NUMBER = "MaxNumber";
    private static final String MIN_STRING = "MinString";
    private static final String MAX_STRING = "MaxString";
    private static final String INFINITY = "Infinity";
    public static final PartitionKeyInternal EmptyPartitionKey = new PartitionKeyInternal(new ArrayList<IPartitionKeyComponent>());
    public static final PartitionKeyInternal InfinityPartitionKey = new PartitionKeyInternal((List<IPartitionKeyComponent>)new ArrayList<IPartitionKeyComponent>(){
        {
            this.add(new InfinityPartitionKeyComponent());
        }
    });
    public static final PartitionKeyInternal InclusiveMinimum = EmptyPartitionKey;
    public static final PartitionKeyInternal ExclusiveMaximum = InfinityPartitionKey;
    public static final PartitionKeyInternal Empty = EmptyPartitionKey;
    final List<IPartitionKeyComponent> components;

    public PartitionKeyInternal(List<IPartitionKeyComponent> values) {
        if (values == null) {
            throw new IllegalArgumentException("values");
        }
        this.components = values;
    }

    public static PartitionKeyInternal fromJsonString(String partitionKey) {
        if (Strings.isNullOrEmpty(partitionKey)) {
            throw new IllegalArgumentException(String.format("Cannot deserialize PartitionKey value '%s", partitionKey));
        }
        try {
            return (PartitionKeyInternal)Utils.getSimpleObjectMapper().readValue(partitionKey, PartitionKeyInternal.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PartitionKeyInternal fromObjectArray(Object[] values, boolean strict) {
        if (values == null) {
            throw new IllegalArgumentException("values");
        }
        return PartitionKeyInternal.fromObjectArray(Arrays.asList(values), strict);
    }

    public static PartitionKeyInternal fromObjectArray(List<Object> values, boolean strict) {
        if (values == null) {
            throw new IllegalArgumentException("values");
        }
        ArrayList<IPartitionKeyComponent> components = new ArrayList<IPartitionKeyComponent>();
        for (Object value : values) {
            if (value == NullNode.instance || value == null) {
                components.add(NullPartitionKeyComponent.VALUE);
                continue;
            }
            if (value instanceof Undefined) {
                components.add(UndefinedPartitionKeyComponent.VALUE);
                continue;
            }
            if (value instanceof Boolean) {
                components.add(new BoolPartitionKeyComponent((Boolean)value));
                continue;
            }
            if (value instanceof String) {
                components.add(new StringPartitionKeyComponent((String)value));
                continue;
            }
            if (PartitionKeyInternal.isNumeric(value)) {
                components.add(new NumberPartitionKeyComponent(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof ObjectNode && ((ObjectNode)value).get(TYPE) != null) {
                switch (((ObjectNode)value).get(TYPE).asText()) {
                    case "MinNumber": {
                        components.add(MinNumberPartitionKeyComponent.VALUE);
                        break;
                    }
                    case "MaxNumber": {
                        components.add(MaxNumberPartitionKeyComponent.VALUE);
                        break;
                    }
                    case "MinString": {
                        components.add(MinStringPartitionKeyComponent.VALUE);
                        break;
                    }
                    case "MaxString": {
                        components.add(MaxStringPartitionKeyComponent.VALUE);
                    }
                }
                continue;
            }
            if (strict) {
                throw new IllegalArgumentException("Unable to construct PartitionKeyInternal from objects array");
            }
            components.add(UndefinedPartitionKeyComponent.VALUE);
        }
        return new PartitionKeyInternal(components);
    }

    private static boolean isNumeric(Object value) {
        return value instanceof Number;
    }

    private static PartitionKeyInternal getExclusiveMaximum() {
        return InfinityPartitionKey;
    }

    public static PartitionKeyInternal getEmpty() {
        return EmptyPartitionKey;
    }

    public boolean equals(Object obj) {
        PartitionKeyInternal pki = com.microsoft.azure.cosmosdb.rx.internal.Utils.as(obj, PartitionKeyInternal.class);
        if (pki == null) {
            return false;
        }
        if (pki == this) {
            return true;
        }
        return this.compareTo(pki) == 0;
    }

    @Override
    public int compareTo(PartitionKeyInternal other) {
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        for (int i = 0; i < Math.min(this.components.size(), other.components.size()); ++i) {
            int rightOrdinal;
            int leftOrdinal = this.components.get(i).GetTypeOrdinal();
            if (leftOrdinal != (rightOrdinal = other.components.get(i).GetTypeOrdinal())) {
                return (int)Math.signum(leftOrdinal - rightOrdinal);
            }
            int result = this.components.get(i).CompareTo(other.components.get(i));
            if (result == 0) continue;
            return (int)Math.signum(result);
        }
        return (int)Math.signum(this.components.size() - other.components.size());
    }

    public String toJson() {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable serialize the partition key internal into the JSON string", e);
        }
    }

    public boolean contains(PartitionKeyInternal nestedPartitionKey) {
        if (this.components.size() > nestedPartitionKey.components.size()) {
            return false;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).CompareTo(nestedPartitionKey.components.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public List<IPartitionKeyComponent> getComponents() {
        return this.components;
    }

    static final class PartitionKeyInternalJsonDeserializer
    extends StdDeserializer<PartitionKeyInternal> {
        protected PartitionKeyInternalJsonDeserializer() {
            this(null);
        }

        protected PartitionKeyInternalJsonDeserializer(Class<?> vc) {
            super(vc);
        }

        public PartitionKeyInternal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            JsonNode root;
            ObjectCodec objectCodec = jsonParser.getCodec();
            try {
                root = (JsonNode)objectCodec.readTree(jsonParser);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (root.isTextual() && root.asText().equals(PartitionKeyInternal.INFINITY)) {
                return PartitionKeyInternal.getExclusiveMaximum();
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            if (root.isArray()) {
                for (JsonNode node : root) {
                    if (node.isNull()) {
                        objects.add(null);
                        continue;
                    }
                    if (node.isNumber()) {
                        objects.add(node.asDouble());
                        continue;
                    }
                    if (node.isBoolean()) {
                        objects.add(node.asBoolean());
                        continue;
                    }
                    if (node.isTextual()) {
                        objects.add(node.asText());
                        continue;
                    }
                    if (node.isArray() && node.size() == 0 || node.isObject() && (node.fields() == null || !node.fields().hasNext())) {
                        objects.add(Undefined.Value());
                        continue;
                    }
                    objects.add(node);
                }
                return PartitionKeyInternal.fromObjectArray(objects, true);
            }
            throw new IllegalStateException(String.format("Unable to deserialize PartitionKeyInternal '%s'", root.toString()));
        }
    }

    static final class PartitionKeyInternalJsonSerializer
    extends StdSerializer<PartitionKeyInternal> {
        protected PartitionKeyInternalJsonSerializer() {
            this(null);
        }

        protected PartitionKeyInternalJsonSerializer(Class<PartitionKeyInternal> t) {
            super(t);
        }

        public void serialize(PartitionKeyInternal partitionKey, JsonGenerator writer, SerializerProvider serializerProvider) {
            try {
                if (partitionKey.equals(PartitionKeyInternal.getExclusiveMaximum())) {
                    writer.writeString(PartitionKeyInternal.INFINITY);
                    return;
                }
                writer.writeStartArray();
                for (IPartitionKeyComponent componentValue : partitionKey.getComponents()) {
                    componentValue.JsonEncode(writer);
                }
                writer.writeEndArray();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        static void jsonEncode(MinNumberPartitionKeyComponent component, JsonGenerator writer) {
            PartitionKeyInternalJsonSerializer.jsonEncodeLimit(writer, PartitionKeyInternal.MIN_NUMBER);
        }

        static void jsonEncode(MaxNumberPartitionKeyComponent component, JsonGenerator writer) {
            PartitionKeyInternalJsonSerializer.jsonEncodeLimit(writer, PartitionKeyInternal.MAX_NUMBER);
        }

        static void jsonEncode(MinStringPartitionKeyComponent component, JsonGenerator writer) {
            PartitionKeyInternalJsonSerializer.jsonEncodeLimit(writer, PartitionKeyInternal.MIN_STRING);
        }

        static void jsonEncode(MaxStringPartitionKeyComponent component, JsonGenerator writer) {
            PartitionKeyInternalJsonSerializer.jsonEncodeLimit(writer, PartitionKeyInternal.MAX_STRING);
        }

        private static void jsonEncodeLimit(JsonGenerator writer, String value) {
            try {
                writer.writeStartObject();
                writer.writeFieldName(PartitionKeyInternal.TYPE);
                writer.writeString(value);
                writer.writeEndObject();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

