/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Resource
extends JsonSerializable {
    private String altLink;

    protected Resource(Resource resource) {
        this.setId(resource.getId());
        this.setResourceId(resource.getResourceId());
        this.setSelfLink(resource.getSelfLink());
        this.setAltLink(resource.getAltLink());
        this.setTimestamp(resource.getTimestamp());
        this.setETag(resource.getETag());
    }

    protected Resource() {
    }

    Resource(ObjectNode objectNode) {
        super(objectNode);
    }

    protected Resource(String jsonString, ObjectMapper objectMapper) {
        super(jsonString, objectMapper);
    }

    protected Resource(String jsonString) {
        super(jsonString);
    }

    public String getId() {
        return super.getString("id");
    }

    public void setId(String id) {
        super.set("id", id);
    }

    public String getResourceId() {
        return super.getString("_rid");
    }

    public void setResourceId(String resourceId) {
        super.set("_rid", resourceId);
    }

    public String getSelfLink() {
        return super.getString("_self");
    }

    void setSelfLink(String selfLink) {
        super.set("_self", selfLink);
    }

    public Date getTimestamp() {
        Double seconds = super.getDouble("_ts");
        if (seconds == null) {
            return null;
        }
        return new Date(TimeUnit.SECONDS.toMillis(seconds.longValue()));
    }

    void setTimestamp(Date timestamp) {
        double millisec = timestamp.getTime();
        super.set("_ts", TimeUnit.MILLISECONDS.toSeconds((long)millisec));
    }

    public String getETag() {
        return super.getString("_etag");
    }

    void setETag(String eTag) {
        super.set("_etag", eTag);
    }

    void setAltLink(String altLink) {
        this.altLink = altLink;
    }

    String getAltLink() {
        return this.altLink;
    }
}

