/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.subjects;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.Subject;

public final class PublishSubjectSingleSubscriber<T>
extends Subject<T, T> {
    static final String ONLY_ONE_SUBSCRIPTION_IS_ALLOWED = "only one subscription is allowed";
    private final SingleSubscribeOnSubscribe<T> onSubscribe;

    private PublishSubjectSingleSubscriber(SingleSubscribeOnSubscribe<T> onSubscribe) {
        super(onSubscribe);
        this.onSubscribe = onSubscribe;
    }

    private PublishSubjectSingleSubscriber() {
        this(new SingleSubscribeOnSubscribe());
    }

    public static <T> PublishSubjectSingleSubscriber<T> create() {
        return new PublishSubjectSingleSubscriber<T>();
    }

    public void onCompleted() {
        Subscriber sub = this.onSubscribe.subscriber.get();
        if (sub != null) {
            sub.onCompleted();
        }
    }

    public void onError(Throwable e) {
        Subscriber sub = this.onSubscribe.subscriber.get();
        if (sub != null) {
            sub.onError(e);
        }
    }

    public void onNext(T t) {
        Subscriber sub = this.onSubscribe.subscriber.get();
        if (sub != null) {
            sub.onNext(t);
        }
    }

    public boolean hasObservers() {
        return this.onSubscribe.subscriber.get() != null;
    }

    private static class SingleSubscribeOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final AtomicReference<Subscriber<? super T>> subscriber = new AtomicReference();

        private SingleSubscribeOnSubscribe() {
        }

        public void call(Subscriber<? super T> sub) {
            if (!this.subscriber.compareAndSet(null, sub)) {
                throw new RuntimeException(PublishSubjectSingleSubscriber.ONLY_ONE_SUBSCRIPTION_IS_ALLOWED);
            }
        }
    }
}

