/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.utils.join;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.contrib.utils.join.JobBase;
import org.apache.hadoop.contrib.utils.join.TaggedMapOutput;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class DataJoinMapperBase
extends JobBase {
    protected String inputFile = null;
    protected JobConf job = null;
    protected Text inputTag = null;
    protected Reporter reporter = null;

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        this.job = job;
        this.inputFile = job.get("mapreduce.map.input.file");
        this.inputTag = this.generateInputTag(this.inputFile);
    }

    protected abstract Text generateInputTag(String var1);

    protected abstract TaggedMapOutput generateTaggedMapOutput(Object var1);

    protected abstract Text generateGroupKey(TaggedMapOutput var1);

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        if (this.reporter == null) {
            this.reporter = reporter;
        }
        this.addLongValue("totalCount", 1L);
        TaggedMapOutput aRecord = this.generateTaggedMapOutput(value);
        if (aRecord == null) {
            this.addLongValue("discardedCount", 1L);
            return;
        }
        Text groupKey = this.generateGroupKey(aRecord);
        if (groupKey == null) {
            this.addLongValue("nullGroupKeyCount", 1L);
            return;
        }
        output.collect((Object)groupKey, (Object)aRecord);
        this.addLongValue("collectedCount", 1L);
    }

    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.setStatus(super.getReport());
        }
    }

    public void reduce(Object arg0, Iterator arg1, OutputCollector arg2, Reporter arg3) throws IOException {
    }
}

