/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAccessTokenTimer {
    @Test
    public void expireConversionWorks() {
        Timer mockTimer = (Timer)Mockito.mock(Timer.class);
        Mockito.when((Object)mockTimer.now()).thenReturn((Object)5L);
        AccessTokenTimer timer = new AccessTokenTimer(mockTimer);
        timer.setExpiresIn("3");
        Assert.assertEquals((long)3005L, (long)timer.getNextRefreshMSSinceEpoch());
        Assert.assertTrue((boolean)timer.shouldRefresh());
    }

    @Test
    public void shouldRefreshIsCorrect() {
        Timer mockTimer = (Timer)Mockito.mock(Timer.class);
        Mockito.when((Object)mockTimer.now()).thenReturn((Object)500L).thenReturn((Object)1000500L);
        AccessTokenTimer timer = new AccessTokenTimer(mockTimer);
        timer.setExpiresInMSSinceEpoch("1000000");
        Assert.assertFalse((boolean)timer.shouldRefresh());
        Assert.assertTrue((boolean)timer.shouldRefresh());
        ((Timer)Mockito.verify((Object)mockTimer, (VerificationMode)Mockito.times((int)2))).now();
    }
}

