/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.common.BlockAlias;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.namenode.BlockResolver;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.TreeWalk;
import org.apache.hadoop.hdfs.server.namenode.UGIResolver;
import org.apache.hadoop.thirdparty.protobuf.ByteString;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TreePath {
    private long id = -1L;
    private final long parentId;
    private final FileStatus stat;
    private final TreeWalk.TreeIterator i;
    private final FileSystem fs;
    private final AclStatus acls;

    @VisibleForTesting
    public TreePath(FileStatus stat, long parentId, TreeWalk.TreeIterator i) {
        this(stat, parentId, i, null, null);
    }

    public TreePath(FileStatus stat, long parentId, TreeWalk.TreeIterator i, FileSystem fs, AclStatus acls) {
        this.i = i;
        this.stat = stat;
        this.parentId = parentId;
        this.fs = fs;
        this.acls = acls;
    }

    public FileStatus getFileStatus() {
        return this.stat;
    }

    public AclStatus getAclStatus() {
        return this.acls;
    }

    public long getParentId() {
        return this.parentId;
    }

    public TreeWalk.TreeIterator getIterator() {
        return this.i;
    }

    public long getId() {
        if (this.id < 0L) {
            throw new IllegalStateException();
        }
        return this.id;
    }

    public void accept(long pathId) {
        this.id = pathId;
        this.i.onAccept(this, this.id);
    }

    public FsImageProto.INodeSection.INode toINode(UGIResolver ugi, BlockResolver blk, BlockAliasMap.Writer<FileRegion> out) throws IOException {
        if (this.stat.isFile()) {
            return this.toFile(ugi, blk, out);
        }
        if (this.stat.isDirectory()) {
            return this.toDirectory(ugi);
        }
        if (this.stat.isSymlink()) {
            throw new UnsupportedOperationException("symlinks not supported");
        }
        throw new UnsupportedOperationException("Unknown type: " + this.stat);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TreePath)) {
            return false;
        }
        TreePath o = (TreePath)other;
        return this.getParentId() == o.getParentId() && this.getFileStatus().equals((Object)o.getFileStatus());
    }

    public int hashCode() {
        long pId = this.getParentId() * (long)this.getFileStatus().hashCode();
        return (int)(pId ^ pId >>> 32);
    }

    void writeBlock(long blockId, long offset, long length, long genStamp, PathHandle pathHandle, BlockAliasMap.Writer<FileRegion> out) throws IOException {
        FileStatus s = this.getFileStatus();
        out.store((BlockAlias)new FileRegion(blockId, s.getPath(), offset, length, genStamp, pathHandle != null ? pathHandle.toByteArray() : new byte[]{}));
    }

    FsImageProto.INodeSection.INode toFile(UGIResolver ugi, BlockResolver blk, BlockAliasMap.Writer<FileRegion> out) throws IOException {
        FileStatus s = this.getFileStatus();
        AclStatus aclStatus = this.getAclStatus();
        long permissions = ugi.getPermissionsProto(s, aclStatus);
        FsImageProto.INodeSection.INodeFile.Builder b = FsImageProto.INodeSection.INodeFile.newBuilder().setReplication(blk.getReplication(s)).setModificationTime(s.getModificationTime()).setAccessTime(s.getAccessTime()).setPreferredBlockSize(blk.preferredBlockSize(s)).setPermission(permissions).setStoragePolicyID(1);
        PathHandle pathHandle = null;
        if (this.fs != null) {
            try {
                pathHandle = this.fs.getPathHandle(s, Options.HandleOpt.exact());
            }
            catch (UnsupportedOperationException e) {
                DFSUtil.LOG.warn("Exact path handle not supported by filesystem " + this.fs.toString());
            }
        }
        if (aclStatus != null) {
            throw new UnsupportedOperationException("ACLs not supported by ImageWriter");
        }
        long off = 0L;
        for (HdfsProtos.BlockProto block : blk.resolve(s)) {
            b.addBlocks(block);
            this.writeBlock(block.getBlockId(), off, block.getNumBytes(), block.getGenStamp(), pathHandle, out);
            off += block.getNumBytes();
        }
        FsImageProto.INodeSection.INode.Builder ib = FsImageProto.INodeSection.INode.newBuilder().setType(FsImageProto.INodeSection.INode.Type.FILE).setId(this.id).setName(ByteString.copyFrom((byte[])DFSUtil.string2Bytes((String)s.getPath().getName()))).setFile(b);
        return ib.build();
    }

    FsImageProto.INodeSection.INode toDirectory(UGIResolver ugi) {
        FileStatus s = this.getFileStatus();
        AclStatus aclStatus = this.getAclStatus();
        long permissions = ugi.getPermissionsProto(s, aclStatus);
        FsImageProto.INodeSection.INodeDirectory.Builder b = FsImageProto.INodeSection.INodeDirectory.newBuilder().setModificationTime(s.getModificationTime()).setNsQuota(Long.MAX_VALUE).setDsQuota(-1L).setPermission(permissions);
        if (aclStatus != null) {
            throw new UnsupportedOperationException("ACLs not supported by ImageWriter");
        }
        FsImageProto.INodeSection.INode.Builder ib = FsImageProto.INodeSection.INode.newBuilder().setType(FsImageProto.INodeSection.INode.Type.DIRECTORY).setId(this.id).setName(ByteString.copyFrom((byte[])DFSUtil.string2Bytes((String)s.getPath().getName()))).setDirectory(b);
        return ib.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ stat=\"").append(this.getFileStatus()).append("\"");
        sb.append(", id=").append(this.getId());
        sb.append(", parentId=").append(this.getParentId());
        sb.append(", iterObjId=").append(System.identityHashCode(this.i));
        sb.append(" }");
        return sb.toString();
    }
}

