/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.util.regex.Pattern;

public class PatternValidator {
    public static final String E_INVALID_NAME = "Invalid name %s does not match the pattern %s ";
    private final Pattern valid;
    private final String pattern;

    public PatternValidator(String pattern) {
        this.pattern = pattern;
        this.valid = Pattern.compile(pattern);
    }

    public void validate(String name) {
        if (!this.matches(name)) {
            throw new IllegalArgumentException(String.format(E_INVALID_NAME, name, this.pattern));
        }
    }

    public boolean matches(String name) {
        return this.valid.matcher(name).matches();
    }
}

