/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.DefaultProbe;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortProbe
extends DefaultProbe {
    protected static final Logger log = LoggerFactory.getLogger(PortProbe.class);
    private final int port;
    private final int timeout;

    public PortProbe(int port, int timeout, Map<String, String> props) {
        super("Port probe of " + port + " for " + timeout + "ms", props);
        this.port = port;
        this.timeout = timeout;
    }

    public static PortProbe create(Map<String, String> props) throws IOException {
        int port = PortProbe.getPropertyInt(props, "port", null);
        if (port >= 65536) {
            throw new IOException("port " + port + " is out of range");
        }
        int timeout = PortProbe.getPropertyInt(props, "timeout", 1000);
        return new PortProbe(port, timeout, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProbeStatus ping(ComponentInstance instance) {
        ProbeStatus status = super.ping(instance);
        if (!status.isSuccess()) {
            return status;
        }
        String ip = (String)instance.getContainerStatus().getIPs().get(0);
        InetSocketAddress sockAddr = new InetSocketAddress(ip, this.port);
        Socket socket = new Socket();
        try {
            if (log.isDebugEnabled()) {
                log.debug(instance.getCompInstanceName() + ": Connecting " + sockAddr.toString() + ", timeout=" + MonitorUtils.millisToHumanTime(this.timeout));
            }
            socket.connect(sockAddr, this.timeout);
            status.succeed(this);
        }
        catch (Throwable e) {
            String error = instance.getCompInstanceName() + ": Probe " + sockAddr + " failed";
            log.debug(error, e);
            status.fail(this, new IOException(error, e));
        }
        finally {
            IOUtils.closeSocket((Socket)socket);
        }
        return status;
    }
}

