/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMonitor
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMonitor.class);
    public ScheduledExecutorService executorService;
    private Map<ContainerId, ComponentInstance> liveInstances = null;
    private ServiceContext context;
    private Configuration conf;

    public ServiceMonitor(String name, ServiceContext context) {
        super(name);
        this.liveInstances = context.scheduler.getLiveInstances();
        this.context = context;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.executorService = Executors.newScheduledThreadPool(1);
        this.conf = conf;
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        long readinessCheckInterval = YarnServiceConf.getLong("yarn.service.readiness-check-interval.seconds", 30L, this.context.service.getConfiguration(), this.conf);
        this.executorService.scheduleAtFixedRate(new ReadinessChecker(), readinessCheckInterval, readinessCheckInterval, TimeUnit.SECONDS);
        long failureResetInterval = YarnServiceConf.getLong("yarn.service.failure-count-reset.window", 21600L, this.context.service.getConfiguration(), this.conf);
        this.executorService.scheduleAtFixedRate(new ContainerFailureReset(), failureResetInterval, failureResetInterval, TimeUnit.SECONDS);
    }

    public void serviceStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private class ContainerFailureReset
    implements Runnable {
        private ContainerFailureReset() {
        }

        @Override
        public void run() {
            for (Component component : ((ServiceMonitor)ServiceMonitor.this).context.scheduler.getAllComponents().values()) {
                component.resetCompFailureCount();
            }
        }
    }

    private class ReadinessChecker
    implements Runnable {
        private ReadinessChecker() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : ServiceMonitor.this.liveInstances.entrySet()) {
                ComponentInstance instance = (ComponentInstance)entry.getValue();
                ProbeStatus status = instance.ping();
                ComponentInstanceState instanceState = instance.getState();
                if (status.isSuccess()) {
                    if (instanceState != ComponentInstanceState.STARTED && instanceState != ComponentInstanceState.REINITIALIZED) continue;
                    LOG.info("Readiness check succeeded for {}: {}", (Object)instance.getCompInstanceName(), (Object)status);
                    instance.handle(new ComponentInstanceEvent((ContainerId)entry.getKey(), ComponentInstanceEventType.BECOME_READY));
                    continue;
                }
                LOG.info("Readiness check failed for {}: {}", (Object)instance.getCompInstanceName(), (Object)status);
                if (instance.getState() != ComponentInstanceState.READY) continue;
                instance.handle(new ComponentInstanceEvent((ContainerId)entry.getKey(), ComponentInstanceEventType.BECOME_NOT_READY));
            }
            for (Component component : ((ServiceMonitor)ServiceMonitor.this).context.scheduler.getAllComponents().values()) {
                if (component.getState() != ComponentState.INIT || !component.areDependenciesReady()) continue;
                LOG.info("[COMPONENT {}]: Dependencies satisfied, ramping up.", (Object)component.getName());
                ComponentEvent event = new ComponentEvent(component.getName(), ComponentEventType.FLEX).setDesired(component.getComponentSpec().getNumberOfContainers());
                component.handle(event);
            }
        }
    }
}

