/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.scheduler;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.lang.RunnableCallable;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.Scheduler;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SchedulerService
extends BaseService
implements Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerService.class);
    private static final String INST_GROUP = "scheduler";
    public static final String PREFIX = "scheduler";
    public static final String CONF_THREADS = "threads";
    private ScheduledExecutorService scheduler;

    public SchedulerService() {
        super("scheduler");
    }

    @Override
    public void init() throws ServiceException {
        int threads = this.getServiceConfig().getInt(CONF_THREADS, 5);
        this.scheduler = new ScheduledThreadPoolExecutor(threads);
        LOG.debug("Scheduler started");
    }

    @Override
    public void destroy() {
        try {
            long limit = Time.now() + 30000L;
            this.scheduler.shutdownNow();
            while (!this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                LOG.debug("Waiting for scheduler to shutdown");
                if (Time.now() <= limit) continue;
                LOG.warn("Gave up waiting for scheduler to shutdown");
                break;
            }
            if (this.scheduler.isTerminated()) {
                LOG.debug("Scheduler shutdown");
            }
        }
        catch (InterruptedException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Class[] getServiceDependencies() {
        return new Class[]{Instrumentation.class};
    }

    @Override
    public Class getInterface() {
        return Scheduler.class;
    }

    @Override
    public void schedule(final Callable<?> callable, long delay, long interval, TimeUnit unit) {
        Check.notNull(callable, "callable");
        if (this.scheduler.isShutdown()) {
            throw new IllegalStateException(MessageFormat.format("Scheduler shutting down, ignoring scheduling of [{}]", callable));
        }
        LOG.debug("Scheduling callable [{}], interval [{}] seconds, delay [{}] in [{}]", new Object[]{callable, delay, interval, unit});
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String instrName = callable.getClass().getSimpleName();
                Instrumentation instr = SchedulerService.this.getServer().get(Instrumentation.class);
                if (SchedulerService.this.getServer().getStatus() == Server.Status.HALTED) {
                    LOG.debug("Skipping [{}], server status [{}]", (Object)callable, (Object)SchedulerService.this.getServer().getStatus());
                    instr.incr("scheduler", instrName + ".skips", 1L);
                } else {
                    LOG.debug("Executing [{}]", (Object)callable);
                    instr.incr("scheduler", instrName + ".execs", 1L);
                    Instrumentation.Cron cron = instr.createCron().start();
                    try {
                        callable.call();
                    }
                    catch (Exception ex) {
                        instr.incr("scheduler", instrName + ".fails", 1L);
                        LOG.error("Error executing [{}], {}", new Object[]{callable, ex.getMessage(), ex});
                    }
                    finally {
                        instr.addCron("scheduler", instrName, cron.stop());
                    }
                }
            }
        };
        this.scheduler.scheduleWithFixedDelay(r, delay, interval, unit);
    }

    @Override
    public void schedule(Runnable runnable, long delay, long interval, TimeUnit unit) {
        this.schedule(new RunnableCallable(runnable), delay, interval, unit);
    }
}

