/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;

@InterfaceAudience.Private
public class HttpFSAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    public static final String CONF_PREFIX = "httpfs.authentication.";
    public static final String HADOOP_HTTP_CONF_PREFIX = "hadoop.http.authentication.";
    static final String[] CONF_PREFIXES = new String[]{"httpfs.authentication.", "hadoop.http.authentication."};
    private static final String SIGNATURE_SECRET_FILE = "signature.secret.file";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Configuration conf = HttpFSServerWebApp.get().getConfig();
        Properties props = HttpServer2.getFilterProperties((Configuration)conf, new ArrayList<String>(Arrays.asList(CONF_PREFIXES)));
        String signatureSecretFile = props.getProperty(SIGNATURE_SECRET_FILE, null);
        if (signatureSecretFile == null) {
            throw new RuntimeException("Undefined property: signature.secret.file");
        }
        if (!this.isRandomSecret(filterConfig)) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(signatureSecretFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                StringBuilder secret = new StringBuilder();
                int c = ((Reader)reader).read();
                while (c > -1) {
                    secret.append((char)c);
                    c = ((Reader)reader).read();
                }
                String secretString = secret.toString();
                if (secretString.isEmpty()) {
                    throw new RuntimeException("No secret in HttpFs signature secret file: " + signatureSecretFile);
                }
                props.setProperty("signature.secret", secretString);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read HttpFS signature secret file: " + signatureSecretFile);
            }
        }
        this.setAuthHandlerClass(props);
        String dtkind = WebHdfsConstants.WEBHDFS_TOKEN_KIND.toString();
        if (conf.getBoolean("httpfs.ssl.enabled", false)) {
            dtkind = WebHdfsConstants.SWEBHDFS_TOKEN_KIND.toString();
        }
        props.setProperty("delegation-token.token-kind", dtkind);
        return props;
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Map proxyuserConf = HttpFSServerWebApp.get().getConfig().getValByRegex("httpfs\\.proxyuser\\.");
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : proxyuserConf.entrySet()) {
            conf.set(((String)entry.getKey()).substring("httpfs.".length()), (String)entry.getValue());
        }
        return conf;
    }

    private boolean isRandomSecret(FilterConfig filterConfig) {
        SignerSecretProvider secretProvider = (SignerSecretProvider)filterConfig.getServletContext().getAttribute("signer.secret.provider.object");
        if (secretProvider == null) {
            return false;
        }
        return secretProvider.getClass() == RandomSignerSecretProvider.class;
    }
}

