/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.request.Range;

public class IOPlan {
    private final ArrayList<Range> prefetchRanges;
    public static final IOPlan EMPTY_PLAN = new IOPlan(Collections.emptyList());

    public IOPlan(@NonNull Range prefetchRange) {
        if (prefetchRange == null) {
            throw new NullPointerException("prefetchRange is marked non-null but is null");
        }
        this.prefetchRanges = new ArrayList(1);
        this.prefetchRanges.add(prefetchRange);
    }

    public IOPlan(@NonNull Collection<Range> prefetchRanges) {
        if (prefetchRanges == null) {
            throw new NullPointerException("prefetchRanges is marked non-null but is null");
        }
        this.prefetchRanges = new ArrayList<Range>(prefetchRanges);
    }

    public String toString() {
        return "[" + this.prefetchRanges.stream().map(Range::toString).collect(Collectors.joining(",")) + "]";
    }

    @Generated
    public ArrayList<Range> getPrefetchRanges() {
        return this.prefetchRanges;
    }
}

