/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "matches", "policy", "parentQueue", "fallbackResult", "create", "value", "customPlacement"})
public class Rule {
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="matches")
    private String matches;
    @JsonProperty(value="policy")
    private Policy policy;
    @JsonProperty(value="parentQueue")
    private String parentQueue;
    @JsonProperty(value="fallbackResult")
    private FallbackResult fallbackResult;
    @JsonProperty(value="create")
    private Boolean create;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="customPlacement")
    private String customPlacement;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="matches")
    public String getMatches() {
        return this.matches;
    }

    @JsonProperty(value="matches")
    public void setMatches(String matches) {
        this.matches = matches;
    }

    @JsonProperty(value="policy")
    public Policy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    @JsonProperty(value="parentQueue")
    public String getParentQueue() {
        return this.parentQueue;
    }

    @JsonProperty(value="parentQueue")
    public void setParentQueue(String parentQueue) {
        this.parentQueue = parentQueue;
    }

    @JsonProperty(value="fallbackResult")
    public FallbackResult getFallbackResult() {
        return this.fallbackResult;
    }

    @JsonProperty(value="fallbackResult")
    public void setFallbackResult(FallbackResult fallbackResult) {
        this.fallbackResult = fallbackResult;
    }

    @JsonProperty(value="create")
    public Boolean getCreate() {
        return this.create;
    }

    @JsonProperty(value="create")
    public void setCreate(Boolean create) {
        this.create = create;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="customPlacement")
    public String getCustomPlacement() {
        return this.customPlacement;
    }

    @JsonProperty(value="customPlacement")
    public void setCustomPlacement(String customPlacement) {
        this.customPlacement = customPlacement;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Rule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("matches");
        sb.append('=');
        sb.append(this.matches == null ? "<null>" : this.matches);
        sb.append(',');
        sb.append("policy");
        sb.append('=');
        sb.append(this.policy == null ? "<null>" : this.policy);
        sb.append(',');
        sb.append("parentQueue");
        sb.append('=');
        sb.append(this.parentQueue == null ? "<null>" : this.parentQueue);
        sb.append(',');
        sb.append("fallbackResult");
        sb.append('=');
        sb.append(this.fallbackResult == null ? "<null>" : this.fallbackResult);
        sb.append(',');
        sb.append("create");
        sb.append('=');
        sb.append(this.create == null ? "<null>" : this.create);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("customPlacement");
        sb.append('=');
        sb.append(this.customPlacement == null ? "<null>" : this.customPlacement);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.fallbackResult == null ? 0 : this.fallbackResult.hashCode());
        result = result * 31 + (this.customPlacement == null ? 0 : this.customPlacement.hashCode());
        result = result * 31 + (this.create == null ? 0 : this.create.hashCode());
        result = result * 31 + (this.parentQueue == null ? 0 : this.parentQueue.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.matches == null ? 0 : this.matches.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.policy == null ? 0 : this.policy.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rule)) {
            return false;
        }
        Rule rhs = (Rule)other;
        return (this.fallbackResult == rhs.fallbackResult || this.fallbackResult != null && this.fallbackResult.equals((Object)rhs.fallbackResult)) && (this.customPlacement == rhs.customPlacement || this.customPlacement != null && this.customPlacement.equals(rhs.customPlacement)) && (this.create == rhs.create || this.create != null && this.create.equals(rhs.create)) && (this.parentQueue == rhs.parentQueue || this.parentQueue != null && this.parentQueue.equals(rhs.parentQueue)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.matches == rhs.matches || this.matches != null && this.matches.equals(rhs.matches)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.policy == rhs.policy || this.policy != null && this.policy.equals((Object)rhs.policy));
    }

    public static enum Type {
        USER("user"),
        GROUP("group"),
        APPLICATION("application");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Policy {
        SPECIFIED("specified"),
        REJECT("reject"),
        DEFAULT_QUEUE("defaultQueue"),
        USER("user"),
        PRIMARY_GROUP("primaryGroup"),
        SECONDARY_GROUP("secondaryGroup"),
        PRIMARY_GROUP_USER("primaryGroupUser"),
        SECONDARY_GROUP_USER("secondaryGroupUser"),
        APPLICATION_NAME("applicationName"),
        SET_DEFAULT_QUEUE("setDefaultQueue"),
        CUSTOM("custom");

        private final String value;
        private static final Map<String, Policy> CONSTANTS;

        private Policy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Policy fromValue(String value) {
            Policy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Policy>();
            for (Policy c : Policy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum FallbackResult {
        SKIP("skip"),
        REJECT("reject"),
        PLACE_DEFAULT("placeDefault");

        private final String value;
        private static final Map<String, FallbackResult> CONSTANTS;

        private FallbackResult(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FallbackResult fromValue(String value) {
            FallbackResult constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FallbackResult>();
            for (FallbackResult c : FallbackResult.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

