/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;

class ResponseUtils {
    private static final int INITIAL_RESPONSE_BUFFER_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(ResponseUtils.class);

    ResponseUtils() {
    }

    public static Observable<String> toString(Observable<ByteBuf> contentObservable) {
        return contentObservable.reduce((Object)new ByteArrayOutputStream(1024), (out, bb) -> {
            try {
                bb.readBytes((OutputStream)out, bb.readableBytes());
                return out;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(out -> new String(out.toByteArray(), StandardCharsets.UTF_8));
    }

    public static Single<StoreResponse> toStoreResponse(HttpClientResponse<ByteBuf> clientResponse) {
        HttpResponseHeaders httpResponseHeaders = clientResponse.getHeaders();
        HttpResponseStatus httpResponseStatus = clientResponse.getStatus();
        Observable<String> contentObservable = clientResponse.getContent() == null ? Observable.just(null) : ResponseUtils.toString((Observable<ByteBuf>)clientResponse.getContent());
        Observable storeResponseObservable = contentObservable.flatMap(content -> {
            try {
                StoreResponse rsp = new StoreResponse(httpResponseStatus.code(), HttpUtils.unescape((List)httpResponseHeaders.entries()), content);
                return Observable.just((Object)rsp);
            }
            catch (Exception e) {
                return Observable.error((Throwable)e);
            }
        });
        return storeResponseObservable.toSingle();
    }

    private static void validateOrThrow(RxDocumentServiceRequest request, HttpResponseStatus status, HttpResponseHeaders headers, String body, InputStream inputStream) throws DocumentClientException {
        int statusCode = status.code();
        if (statusCode >= 400) {
            if (body == null && inputStream != null) {
                try {
                    body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    logger.error("Failed to get content from the http response", (Throwable)e);
                    throw new IllegalStateException("Failed to get content from the http response", e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            String statusCodeString = status.reasonPhrase() != null ? status.reasonPhrase().replace(" ", "") : "";
            Error error = null;
            error = body != null ? new Error(body) : new Error();
            error = new Error(statusCodeString, String.format("%s, StatusCode: %s", error.getMessage(), statusCodeString), error.getPartitionedQueryExecutionInfo());
            throw new DocumentClientException(statusCode, error, HttpUtils.asMap((HttpResponseHeaders)headers));
        }
    }
}

