/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma;

import org.multiverse.api.BackoffPolicy;
import org.multiverse.api.IsolationLevel;
import org.multiverse.api.LockMode;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.Stm;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.TxnFactoryBuilder;
import org.multiverse.api.collections.TxnCollectionsFactory;
import org.multiverse.api.lifecycle.TxnListener;
import org.multiverse.collections.NaiveTxnCollectionFactory;
import org.multiverse.stms.gamma.FatGammaTxnExecutor;
import org.multiverse.stms.gamma.GammaOrElseBlock;
import org.multiverse.stms.gamma.GammaStmConfig;
import org.multiverse.stms.gamma.GammaTxnExecutor;
import org.multiverse.stms.gamma.GammaTxnRefFactory;
import org.multiverse.stms.gamma.GammaTxnRefFactoryBuilder;
import org.multiverse.stms.gamma.GlobalConflictCounter;
import org.multiverse.stms.gamma.LeanGammaTxnExecutor;
import org.multiverse.stms.gamma.transactionalobjects.GammaTxnBoolean;
import org.multiverse.stms.gamma.transactionalobjects.GammaTxnDouble;
import org.multiverse.stms.gamma.transactionalobjects.GammaTxnInteger;
import org.multiverse.stms.gamma.transactionalobjects.GammaTxnLong;
import org.multiverse.stms.gamma.transactionalobjects.GammaTxnRef;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.stms.gamma.transactions.GammaTxnFactory;
import org.multiverse.stms.gamma.transactions.GammaTxnFactoryBuilder;
import org.multiverse.stms.gamma.transactions.GammaTxnPool;
import org.multiverse.stms.gamma.transactions.SpeculativeGammaConfiguration;
import org.multiverse.stms.gamma.transactions.ThreadLocalGammaTxnPool;
import org.multiverse.stms.gamma.transactions.fat.FatFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatMonoGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatVariableLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanMonoGammaTxn;

public final class GammaStm
implements Stm {
    public final int defaultMaxRetries;
    public final int spinCount;
    public final BackoffPolicy defaultBackoffPolicy;
    public final GlobalConflictCounter globalConflictCounter = new GlobalConflictCounter();
    public final GammaTxnRefFactoryImpl defaultRefFactory = new GammaTxnRefFactoryImpl();
    public final GammaTxnRefFactoryBuilder refFactoryBuilder = new GammaTxnRefFactoryBuilderImpl();
    public final GammaTxnExecutor defaultxnExecutor;
    public final GammaTxnConfig defaultConfig;
    public final NaiveTxnCollectionFactory defaultTransactionalCollectionFactory = new NaiveTxnCollectionFactory(this);
    public final int readBiasedThreshold;
    public final GammaOrElseBlock defaultOrElseBlock = new GammaOrElseBlock();

    public static GammaStm createFast() {
        return new GammaStm();
    }

    public GammaStm() {
        this(new GammaStmConfig());
    }

    public GammaStm(GammaStmConfig config) {
        config.validate();
        this.defaultMaxRetries = config.maxRetries;
        this.spinCount = config.spinCount;
        this.defaultBackoffPolicy = config.backoffPolicy;
        this.defaultConfig = new GammaTxnConfig(this, config).setSpinCount(this.spinCount);
        this.defaultxnExecutor = this.newTxnFactoryBuilder().setSpeculative(false).newTxnExecutor();
        this.readBiasedThreshold = config.readBiasedThreshold;
    }

    @Override
    public final GammaTxn newDefaultTxn() {
        return new FatVariableLengthGammaTxn(this);
    }

    @Override
    public final GammaTxnExecutor getDefaultTxnExecutor() {
        return this.defaultxnExecutor;
    }

    @Override
    public final GammaOrElseBlock newOrElseBlock() {
        return this.defaultOrElseBlock;
    }

    public final GlobalConflictCounter getGlobalConflictCounter() {
        return this.globalConflictCounter;
    }

    @Override
    public final GammaTxnRefFactory getDefaultRefFactory() {
        return this.defaultRefFactory;
    }

    @Override
    public final GammaTxnFactoryBuilder newTxnFactoryBuilder() {
        GammaTxnConfig config = new GammaTxnConfig(this);
        return new GammaTxnFactoryBuilderImpl(config);
    }

    @Override
    public final TxnCollectionsFactory getDefaultTxnCollectionFactory() {
        return this.defaultTransactionalCollectionFactory;
    }

    @Override
    public final GammaTxnRefFactoryBuilder getTxRefFactoryBuilder() {
        return this.refFactoryBuilder;
    }

    private static final class SpeculativeGammaTxnFactory
    implements GammaTxnFactory {
        private final GammaTxnConfig config;
        private final GammaTxnFactoryBuilder builder;

        SpeculativeGammaTxnFactory(GammaTxnConfig config, GammaTxnFactoryBuilder builder) {
            this.config = config.init();
            this.builder = builder;
        }

        @Override
        public GammaTxnFactoryBuilder getTxnFactoryBuilder() {
            return this.builder;
        }

        @Override
        public final GammaTxnConfig getConfig() {
            return this.config;
        }

        @Override
        public final GammaTxn newTxn() {
            return this.newTransaction(ThreadLocalGammaTxnPool.getThreadLocalGammaTxnPool());
        }

        @Override
        public final GammaTxn upgradeAfterSpeculativeFailure(GammaTxn failingTx, GammaTxnPool pool) {
            GammaTxn tx = this.newTransaction(pool);
            tx.copyForSpeculativeFailure(failingTx);
            return tx;
        }

        @Override
        public final GammaTxn newTransaction(GammaTxnPool pool) {
            SpeculativeGammaConfiguration speculativeConfiguration = this.config.speculativeConfiguration.get();
            int length = speculativeConfiguration.minimalLength;
            if (length <= 1) {
                if (speculativeConfiguration.fat) {
                    FatMonoGammaTxn tx = pool.takeFatMono();
                    if (tx == null) {
                        return new FatMonoGammaTxn(this.config);
                    }
                    tx.init(this.config);
                    return tx;
                }
                LeanMonoGammaTxn tx = pool.takeLeanMono();
                if (tx == null) {
                    return new LeanMonoGammaTxn(this.config);
                }
                tx.init(this.config);
                return tx;
            }
            if (length <= this.config.maxFixedLengthTransactionSize) {
                if (speculativeConfiguration.fat) {
                    FatFixedLengthGammaTxn tx = pool.takeFatFixedLength();
                    if (tx == null) {
                        return new FatFixedLengthGammaTxn(this.config);
                    }
                    tx.init(this.config);
                    return tx;
                }
                LeanFixedLengthGammaTxn tx = pool.takeLeanFixedLength();
                if (tx == null) {
                    return new LeanFixedLengthGammaTxn(this.config);
                }
                tx.init(this.config);
                return tx;
            }
            FatVariableLengthGammaTxn tx = pool.takeMap();
            if (tx == null) {
                return new FatVariableLengthGammaTxn(this.config);
            }
            tx.init(this.config);
            return tx;
        }
    }

    private static final class NonSpeculativeGammaTxnFactory
    implements GammaTxnFactory {
        private final GammaTxnConfig config;
        private final GammaTxnFactoryBuilder builder;

        NonSpeculativeGammaTxnFactory(GammaTxnConfig config, GammaTxnFactoryBuilder builder) {
            this.config = config.init();
            this.builder = builder;
        }

        @Override
        public TxnFactoryBuilder getTxnFactoryBuilder() {
            return this.builder;
        }

        @Override
        public final GammaTxnConfig getConfig() {
            return this.config;
        }

        @Override
        public final GammaTxn newTxn() {
            return this.newTransaction(ThreadLocalGammaTxnPool.getThreadLocalGammaTxnPool());
        }

        @Override
        public final GammaTxn newTransaction(GammaTxnPool pool) {
            FatVariableLengthGammaTxn tx = pool.takeMap();
            if (tx == null) {
                tx = new FatVariableLengthGammaTxn(this.config);
            } else {
                tx.init(this.config);
            }
            return tx;
        }

        @Override
        public final GammaTxn upgradeAfterSpeculativeFailure(GammaTxn tailingTx, GammaTxnPool pool) {
            throw new UnsupportedOperationException();
        }
    }

    private final class GammaTxnRefFactoryBuilderImpl
    implements GammaTxnRefFactoryBuilder {
        private GammaTxnRefFactoryBuilderImpl() {
        }

        @Override
        public GammaTxnRefFactory build() {
            return new GammaTxnRefFactoryImpl();
        }
    }

    private final class GammaTxnRefFactoryImpl
    implements GammaTxnRefFactory {
        private GammaTxnRefFactoryImpl() {
        }

        @Override
        public final <E> GammaTxnRef<E> newTxnRef(E value) {
            return new GammaTxnRef<E>(GammaStm.this, value);
        }

        @Override
        public final GammaTxnInteger newTxnInteger(int value) {
            return new GammaTxnInteger(GammaStm.this, value);
        }

        @Override
        public final GammaTxnBoolean newTxnBoolean(boolean value) {
            return new GammaTxnBoolean(GammaStm.this, value);
        }

        @Override
        public final GammaTxnDouble newTxnDouble(double value) {
            return new GammaTxnDouble(GammaStm.this, value);
        }

        @Override
        public final GammaTxnLong newTxnLong(long value) {
            return new GammaTxnLong(GammaStm.this, value);
        }
    }

    private final class GammaTxnFactoryBuilderImpl
    implements GammaTxnFactoryBuilder {
        private final GammaTxnConfig config;

        GammaTxnFactoryBuilderImpl(GammaTxnConfig config) {
            this.config = config;
        }

        @Override
        public final GammaTxnFactoryBuilder setFat() {
            if (this.config.isFat) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setFat());
        }

        @Override
        public final GammaTxnConfig getConfig() {
            return this.config;
        }

        @Override
        public GammaTxnFactoryBuilder addPermanentListener(TxnListener listener) {
            return new GammaTxnFactoryBuilderImpl(this.config.addPermanentListener(listener));
        }

        @Override
        public final GammaTxnFactoryBuilder setControlFlowErrorsReused(boolean reused) {
            this.config.controlFlowErrorsReused = reused;
            if (this.config.controlFlowErrorsReused) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setControlFlowErrorsReused(reused));
        }

        @Override
        public final GammaTxnFactoryBuilder setReadLockMode(LockMode lockMode) {
            if (this.config.readLockMode == lockMode) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setReadLockMode(lockMode));
        }

        @Override
        public final GammaTxnFactoryBuilder setWriteLockMode(LockMode lockMode) {
            if (this.config.writeLockMode == lockMode) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setWriteLockMode(lockMode));
        }

        @Override
        public final GammaTxnFactoryBuilder setFamilyName(String familyName) {
            if (this.config.familyName.equals(familyName)) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setFamilyName(familyName));
        }

        @Override
        public final GammaTxnFactoryBuilder setPropagationLevel(PropagationLevel level) {
            if (level == this.config.propagationLevel) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setPropagationLevel(level));
        }

        @Override
        public final GammaTxnFactoryBuilder setBlockingAllowed(boolean blockingAllowed) {
            if (blockingAllowed == this.config.blockingAllowed) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setBlockingAllowed(blockingAllowed));
        }

        @Override
        public final GammaTxnFactoryBuilder setIsolationLevel(IsolationLevel isolationLevel) {
            if (isolationLevel == this.config.isolationLevel) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setIsolationLevel(isolationLevel));
        }

        @Override
        public final GammaTxnFactoryBuilder setTraceLevel(TraceLevel traceLevel) {
            if (traceLevel == this.config.traceLevel) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setTraceLevel(traceLevel));
        }

        @Override
        public final GammaTxnFactoryBuilder setTimeoutNs(long timeoutNs) {
            if (timeoutNs == this.config.timeoutNs) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setTimeoutNs(timeoutNs));
        }

        @Override
        public final GammaTxnFactoryBuilder setInterruptible(boolean interruptible) {
            if (interruptible == this.config.interruptible) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setInterruptible(interruptible));
        }

        @Override
        public final GammaTxnFactoryBuilder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == this.config.backoffPolicy) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setBackoffPolicy(backoffPolicy));
        }

        @Override
        public final GammaTxnFactoryBuilder setDirtyCheckEnabled(boolean dirtyCheckEnabled) {
            if (dirtyCheckEnabled == this.config.dirtyCheck) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setDirtyCheckEnabled(dirtyCheckEnabled));
        }

        @Override
        public final GammaTxnFactoryBuilder setSpinCount(int spinCount) {
            if (spinCount == this.config.spinCount) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setSpinCount(spinCount));
        }

        @Override
        public final GammaTxnFactoryBuilder setSpeculative(boolean enabled) {
            if (enabled == this.config.speculative) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setSpeculative(enabled));
        }

        @Override
        public final GammaTxnFactoryBuilder setReadonly(boolean readonly) {
            if (readonly == this.config.readonly) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setReadonly(readonly));
        }

        @Override
        public final GammaTxnFactoryBuilder setReadTrackingEnabled(boolean enabled) {
            if (enabled == this.config.trackReads) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setReadTrackingEnabled(enabled));
        }

        @Override
        public final GammaTxnFactoryBuilder setMaxRetries(int maxRetries) {
            if (maxRetries == this.config.maxRetries) {
                return this;
            }
            return new GammaTxnFactoryBuilderImpl(this.config.setMaxRetries(maxRetries));
        }

        @Override
        public final GammaTxnExecutor newTxnExecutor() {
            this.config.init();
            if (this.isLean()) {
                return new LeanGammaTxnExecutor(this.newTransactionFactory());
            }
            return new FatGammaTxnExecutor(this.newTransactionFactory());
        }

        private boolean isLean() {
            return this.config.propagationLevel == PropagationLevel.Requires;
        }

        @Override
        public GammaTxnFactory newTransactionFactory() {
            this.config.init();
            if (this.config.isSpeculative()) {
                return new SpeculativeGammaTxnFactory(this.config, this);
            }
            return new NonSpeculativeGammaTxnFactory(this.config, this);
        }
    }
}

