/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.gpars.GParsConfig;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.Select;
import groovyx.gpars.dataflow.SelectableChannel;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class Dataflow {
    public static final PGroup DATA_FLOW_GROUP = new DefaultPGroup(GParsConfig.retrieveDefaultPool());
    public static final ThreadLocal<PGroup> activeParallelGroup = new ThreadLocal();

    public static PGroup retrieveCurrentDFPGroup() {
        PGroup pGroup = activeParallelGroup.get();
        if (pGroup == null) {
            pGroup = DATA_FLOW_GROUP;
        }
        return pGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object usingGroup(PGroup group, Closure code) {
        PGroup original = activeParallelGroup.get();
        try {
            activeParallelGroup.set(group);
            Object object = code.call();
            return object;
        }
        finally {
            activeParallelGroup.set(original);
        }
    }

    public static <T> Promise<T> task(Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().task(code);
    }

    public static <T> Promise<T> task(Callable<T> callable) {
        return Dataflow.retrieveCurrentDFPGroup().task(callable);
    }

    public static Promise<Object> task(Runnable runnable) {
        return Dataflow.retrieveCurrentDFPGroup().task(runnable);
    }

    public static <T> Promise<T> lazyTask(Closure<T> code) {
        PGroup group = Dataflow.retrieveCurrentDFPGroup();
        return group.lazyTask(code);
    }

    public static <T> Promise<T> lazyTask(Callable<T> callable) {
        return Dataflow.retrieveCurrentDFPGroup().lazyTask(callable);
    }

    public static DataflowProcessor operator(Map channels, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().operator(channels, code);
    }

    public static DataflowProcessor operator(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().operator(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor operator(List inputChannels, List outputChannels, int maxForks, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().operator(inputChannels, outputChannels, maxForks, code);
    }

    public static DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().operator(input, output, code);
    }

    public static DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, int maxForks, @DelegatesTo(value=DataflowOperator.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().operator(input, output, maxForks, code);
    }

    public static DataflowProcessor selector(Map channels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().selector(channels, code);
    }

    public static DataflowProcessor selector(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().selector(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor selector(Map channels) {
        return Dataflow.retrieveCurrentDFPGroup().selector(channels);
    }

    public static DataflowProcessor selector(List inputChannels, List outputChannels) {
        return Dataflow.retrieveCurrentDFPGroup().selector(inputChannels, outputChannels);
    }

    public static DataflowProcessor prioritySelector(Map channels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().prioritySelector(channels, code);
    }

    public static DataflowProcessor prioritySelector(List inputChannels, List outputChannels, @DelegatesTo(value=DataflowSelector.class) Closure code) {
        return Dataflow.retrieveCurrentDFPGroup().prioritySelector(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor prioritySelector(Map channels) {
        return Dataflow.retrieveCurrentDFPGroup().prioritySelector(channels);
    }

    public static DataflowProcessor prioritySelector(List inputChannels, List outputChannels) {
        return Dataflow.retrieveCurrentDFPGroup().prioritySelector(inputChannels, outputChannels);
    }

    public static DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels) {
        return Dataflow.retrieveCurrentDFPGroup().splitter(inputChannel, outputChannels);
    }

    public static DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels, int maxForks) {
        return Dataflow.retrieveCurrentDFPGroup().splitter(inputChannel, outputChannels, maxForks);
    }

    public static Select<?> select(SelectableChannel<?> ... channels) {
        return Dataflow.retrieveCurrentDFPGroup().select(channels);
    }

    public static Select<?> select(List<SelectableChannel> channels) {
        return Dataflow.retrieveCurrentDFPGroup().select(channels);
    }

    public static <T> Promise<T> whenAllBound(List<Promise> promises, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(promises, code);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1), code);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2), code);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2, promise3), code);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Promise promise4, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2, promise3, promise4), code);
    }

    public static <T> Promise<T> whenAllBound(List<Promise> promises, Closure<T> code, Closure<T> errorHandler) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(promises, code, errorHandler);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Closure<T> code, Closure<T> errorHandler) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1), code, errorHandler);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Closure<T> code, Closure<T> errorHandler) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2), code, errorHandler);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Closure<T> code, Closure<T> errorHandler) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2, promise3), code, errorHandler);
    }

    public static <T> Promise<T> whenAllBound(Promise promise1, Promise promise2, Promise promise3, Promise promise4, Closure<T> code, Closure<T> errorHandler) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(Arrays.asList(promise1, promise2, promise3, promise4), code, errorHandler);
    }
}

