/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Model;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.types.ColumnList;

@Internal
public class ModelImpl
implements Model {
    private final TableEnvironmentInternal tableEnvironment;
    private final ContextResolvedModel model;

    private ModelImpl(TableEnvironmentInternal tableEnvironment, ContextResolvedModel model) {
        this.tableEnvironment = tableEnvironment;
        this.model = model;
    }

    public static ModelImpl createModel(TableEnvironmentInternal tableEnvironment, ContextResolvedModel model) {
        return new ModelImpl(tableEnvironment, model);
    }

    public ContextResolvedModel getModel() {
        return this.model;
    }

    @Override
    public ResolvedSchema getResolvedInputSchema() {
        return this.model.getResolvedModel().getResolvedInputSchema();
    }

    @Override
    public ResolvedSchema getResolvedOutputSchema() {
        return this.model.getResolvedModel().getResolvedOutputSchema();
    }

    public TableEnvironment getTableEnv() {
        return this.tableEnvironment;
    }

    @Override
    public Table predict(Table table, ColumnList inputColumns) {
        return this.predict(table, inputColumns, Map.of());
    }

    @Override
    public Table predict(Table table, ColumnList inputColumns, Map<String, String> options) {
        if (options.isEmpty()) {
            return this.tableEnvironment.fromCall(BuiltInFunctionDefinitions.ML_PREDICT.getName(), table.asArgument("INPUT"), this.asArgument("MODEL"), new ApiExpression(ApiExpressionUtils.valueLiteral(inputColumns)).asArgument("ARGS"));
        }
        ArrayList configKVs = new ArrayList();
        options.forEach((k, v) -> {
            configKVs.add(k);
            configKVs.add(v);
        });
        return this.tableEnvironment.fromCall(BuiltInFunctionDefinitions.ML_PREDICT.getName(), table.asArgument("INPUT"), this.asArgument("MODEL"), new ApiExpression(ApiExpressionUtils.valueLiteral(inputColumns)).asArgument("ARGS"), Expressions.map(configKVs.get(0), configKVs.get(1), configKVs.subList(2, configKVs.size()).toArray()).asArgument("CONFIG"));
    }

    @Override
    public ApiExpression asArgument(String name) {
        return new ApiExpression(ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.ASSIGNMENT, Expressions.lit(name), ApiExpressionUtils.modelRef(name, this)));
    }

    public TableEnvironment getTableEnvironment() {
        return this.tableEnvironment;
    }
}

