/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.datagen.table.DataGeneratorContainer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
public abstract class DataGenVisitorBase
extends LogicalTypeDefaultVisitor<DataGeneratorContainer> {
    protected final String name;
    protected final ReadableConfig config;

    protected DataGenVisitorBase(String name, ReadableConfig config) {
        this.name = name;
        this.config = config;
    }

    @Override
    public DataGeneratorContainer visit(DateType dateType) {
        return DataGeneratorContainer.of(TimeGenerator.of(() -> (int)LocalDate.now().toEpochDay()), new ConfigOption[0]);
    }

    @Override
    public DataGeneratorContainer visit(TimeType timeType) {
        return DataGeneratorContainer.of(TimeGenerator.of(() -> LocalTime.now().get(ChronoField.MILLI_OF_DAY)), new ConfigOption[0]);
    }

    @Override
    protected DataGeneratorContainer defaultMethod(LogicalType logicalType) {
        throw new ValidationException("Unsupported type: " + String.valueOf(logicalType));
    }

    private static abstract class TimeGenerator<T>
    implements DataGenerator<T> {
        private TimeGenerator() {
        }

        public static <T> TimeGenerator<T> of(final SerializableSupplier<T> supplier) {
            return new TimeGenerator<T>(){

                public T next() {
                    return supplier.get();
                }
            };
        }

        public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        }

        public boolean hasNext() {
            return true;
        }
    }

    private static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }
}

