/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.sequencedmultisetstate.AdaptiveSequencedMultiSetState;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetStateContext;
import org.apache.flink.table.runtime.sequencedmultisetstate.ValueStateMultiSetState;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.LinkedMultiSetState;
import org.apache.flink.util.Preconditions;

@Internal
public interface SequencedMultiSetState<T> {
    public StateChangeInfo<T> add(T var1, long var2) throws Exception;

    public StateChangeInfo<T> append(T var1, long var2) throws Exception;

    public StateChangeInfo<T> remove(T var1) throws Exception;

    public Iterator<Tuple2<T, Long>> iterator() throws Exception;

    public boolean isEmpty() throws IOException;

    public void clear();

    public void loadCache() throws IOException;

    public void clearCache();

    public static SequencedMultiSetState<RowData> create(SequencedMultiSetStateContext parameters, RuntimeContext ctx, String backendTypeIdentifier) {
        switch (parameters.config.getStrategy()) {
            case MAP_STATE: {
                return LinkedMultiSetState.create(parameters, ctx);
            }
            case VALUE_STATE: {
                return ValueStateMultiSetState.create(parameters, ctx);
            }
            case ADAPTIVE: {
                return AdaptiveSequencedMultiSetState.create(parameters.config, backendTypeIdentifier, ValueStateMultiSetState.create(parameters, ctx), LinkedMultiSetState.create(parameters, ctx));
            }
        }
        throw new UnsupportedOperationException(parameters.config.getStrategy().name());
    }

    public static enum Strategy {
        VALUE_STATE,
        MAP_STATE,
        ADAPTIVE;

    }

    public static enum StateChangeType {
        ADDITION{

            @Override
            public <T> void validate(long sizeBefore, long sizeAfter, T payload) {
                Preconditions.checkArgument((sizeAfter == sizeBefore + 1L || sizeAfter == sizeBefore ? 1 : 0) != 0);
            }
        }
        ,
        REMOVAL_NOT_FOUND{

            @Override
            public <T> void validate(long sizeBefore, long sizeAfter, T payload) {
                Preconditions.checkArgument((sizeAfter == sizeBefore ? 1 : 0) != 0);
                Preconditions.checkArgument((payload == null ? 1 : 0) != 0);
            }
        }
        ,
        REMOVAL_ALL{

            @Override
            public <T> void validate(long sizeBefore, long sizeAfter, T payload) {
                Preconditions.checkArgument((sizeBefore > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((sizeAfter == 0L ? 1 : 0) != 0);
                Preconditions.checkNotNull(payload);
            }
        }
        ,
        REMOVAL_LAST_ADDED{

            @Override
            public <T> void validate(long sizeBefore, long sizeAfter, T payload) {
                Preconditions.checkArgument((sizeAfter == sizeBefore - 1L ? 1 : 0) != 0);
                Preconditions.checkNotNull(payload);
            }
        }
        ,
        REMOVAL_OTHER{

            @Override
            public <T> void validate(long sizeBefore, long sizeAfter, T payload) {
                Preconditions.checkArgument((sizeAfter == sizeBefore - 1L ? 1 : 0) != 0);
                Preconditions.checkArgument((payload == null ? 1 : 0) != 0);
            }
        };


        public abstract <T> void validate(long var1, long var3, T var5);
    }

    public static class StateChangeInfo<T> {
        private final StateChangeType changeType;
        private final long sizeBefore;
        private final long sizeAfter;
        @Nullable
        private final T payload;

        public static <T> StateChangeInfo<T> forAddition(long sizeBefore, long sizeAfter) {
            return new StateChangeInfo<Object>(sizeBefore, sizeAfter, StateChangeType.ADDITION, null);
        }

        public static <T> StateChangeInfo<T> forRemovedLastAdded(long sizeBefore, long sizeAfter, T payload) {
            return new StateChangeInfo<T>(sizeBefore, sizeAfter, StateChangeType.REMOVAL_LAST_ADDED, payload);
        }

        public static <T> StateChangeInfo<T> forRemovedOther(long sizeBefore, long sizeAfter) {
            return new StateChangeInfo<Object>(sizeBefore, sizeAfter, StateChangeType.REMOVAL_OTHER, null);
        }

        public static <T> StateChangeInfo<T> forAllRemoved(long sizeBefore, long sizeAfter, T payload) {
            return new StateChangeInfo<T>(sizeBefore, sizeAfter, StateChangeType.REMOVAL_ALL, payload);
        }

        public static <T> StateChangeInfo<T> forRemovalNotFound(long size) {
            return new StateChangeInfo<Object>(size, size, StateChangeType.REMOVAL_NOT_FOUND, null);
        }

        private StateChangeInfo(long sizeBefore, long sizeAfter, StateChangeType changeType, @Nullable T payload) {
            changeType.validate(sizeBefore, sizeAfter, payload);
            this.sizeBefore = sizeBefore;
            this.sizeAfter = sizeAfter;
            this.changeType = changeType;
            this.payload = payload;
        }

        public long getSizeAfter() {
            return this.sizeAfter;
        }

        public boolean wasEmpty() {
            return this.sizeBefore == 0L;
        }

        public StateChangeType getChangeType() {
            return this.changeType;
        }

        public Optional<T> getPayload() {
            return Optional.ofNullable(this.payload);
        }
    }
}

