/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.values;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.streaming.api.lineage.DefaultLineageDataset;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.LineageVertexProvider;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedInput;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesInputFormat
extends GenericInputFormat<RowData>
implements NonParallelInput,
ResultTypeQueryable<RowData>,
LineageVertexProvider {
    private static final String LINEAGE_NAMESPACE = "values://ValuesInputFormat";
    private static final Logger LOG = LoggerFactory.getLogger(ValuesInputFormat.class);
    private static final long serialVersionUID = 1L;
    private GeneratedInput<GenericInputFormat<RowData>> generatedInput;
    private final InternalTypeInfo<RowData> returnType;
    private GenericInputFormat<RowData> format;

    public ValuesInputFormat(GeneratedInput<GenericInputFormat<RowData>> generatedInput, InternalTypeInfo<RowData> returnType) {
        this.generatedInput = generatedInput;
        this.returnType = returnType;
    }

    public void open(GenericInputSplit split) {
        LOG.debug("Compiling GenericInputFormat: {} \n\n Code:\n{}", (Object)this.generatedInput.getClassName(), (Object)this.generatedInput.getCode());
        LOG.debug("Instantiating GenericInputFormat.");
        this.format = (GenericInputFormat)this.generatedInput.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.generatedInput = null;
    }

    public boolean reachedEnd() throws IOException {
        return this.format.reachedEnd();
    }

    public RowData nextRecord(RowData reuse) throws IOException {
        return (RowData)this.format.nextRecord((Object)reuse);
    }

    public InternalTypeInfo<RowData> getProducedType() {
        return this.returnType;
    }

    public LineageVertex getLineageVertex() {
        return new SourceLineageVertex(){

            public Boundedness boundedness() {
                return Boundedness.BOUNDED;
            }

            public List<LineageDataset> datasets() {
                return Arrays.asList(new DefaultLineageDataset("", ValuesInputFormat.LINEAGE_NAMESPACE, new HashMap()));
            }
        };
    }
}

