/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.data.RowData;

public interface FilterCondition
extends RichFunction {
    public boolean apply(Context var1, RowData var2);

    public static interface Context {
        public static final Context INVALID_CONTEXT = new Context(){

            @Override
            public Long timestamp() {
                throw new TableRuntimeException("Access to timestamp is not supported in this context.");
            }

            @Override
            public TimerService timerService() {
                throw new TableRuntimeException("Access to timerService is not supported in this context.");
            }
        };

        public Long timestamp();

        public TimerService timerService();

        public static Context of(final KeyedProcessFunction.Context context) {
            return new Context(){

                @Override
                public Long timestamp() {
                    return context.timestamp();
                }

                @Override
                public TimerService timerService() {
                    return context.timerService();
                }
            };
        }

        public static Context of(final ProcessFunction.Context context) {
            return new Context(){

                @Override
                public Long timestamp() {
                    return context.timestamp();
                }

                @Override
                public TimerService timerService() {
                    return context.timerService();
                }
            };
        }
    }
}

