/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.Formatter;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class PrintfFunction
extends BuiltInScalarFunction {
    public PrintfFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.PRINTF, context);
    }

    @Nullable
    public StringData eval(@Nullable StringData format, Object ... obj) {
        if (format == null) {
            return null;
        }
        StringBuilder strBuf = new StringBuilder();
        try (Formatter formatter = new Formatter(strBuf, Locale.US);){
            formatter.format(format.toString(), obj);
        }
        catch (Throwable t) {
            return null;
        }
        return BinaryStringData.fromString((String)strBuf.toString());
    }
}

